/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.io.Serializable;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.Loader;
import org.hibernate.loader.entity.BatchingEntityLoader;
import org.hibernate.loader.entity.BatchingEntityLoaderBuilder;
import org.hibernate.loader.entity.EntityLoader;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.OuterJoinLoadable;

public class LegacyBatchingEntityLoaderBuilder
extends BatchingEntityLoaderBuilder {
    public static final LegacyBatchingEntityLoaderBuilder INSTANCE = new LegacyBatchingEntityLoaderBuilder();

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new LegacyBatchingEntityLoader(persister, batchSize, lockMode, factory, influencers);
    }

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new LegacyBatchingEntityLoader(persister, batchSize, lockOptions, factory, influencers);
    }

    public static class LegacyBatchingEntityLoader
    extends BatchingEntityLoader
    implements UniqueEntityLoader {
        private final int[] batchSizes;
        private final Loader[] loaders;

        public LegacyBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            super(persister);
            this.batchSizes = ArrayHelper.getBatchSizes(maxBatchSize);
            this.loaders = new Loader[this.batchSizes.length];
            for (int i2 = 0; i2 < this.batchSizes.length; ++i2) {
                this.loaders[i2] = new EntityLoader(persister, this.batchSizes[i2], lockMode, factory, loadQueryInfluencers);
            }
        }

        public LegacyBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            super(persister);
            this.batchSizes = ArrayHelper.getBatchSizes(maxBatchSize);
            this.loaders = new Loader[this.batchSizes.length];
            for (int i2 = 0; i2 < this.batchSizes.length; ++i2) {
                this.loaders[i2] = new EntityLoader(persister, this.batchSizes[i2], lockOptions, factory, loadQueryInfluencers);
            }
        }

        @Override
        public Object load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions) {
            return this.load(id, optionalObject, session, lockOptions, null);
        }

        @Override
        public Object load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions, Boolean readOnly) {
            Serializable[] batch = session.getPersistenceContextInternal().getBatchFetchQueue().getEntityBatch(this.persister(), id, this.batchSizes[0], this.persister().getEntityMode());
            for (int i2 = 0; i2 < this.batchSizes.length - 1; ++i2) {
                int smallBatchSize = this.batchSizes[i2];
                if (batch[smallBatchSize - 1] == null) continue;
                Serializable[] smallBatch = new Serializable[smallBatchSize];
                System.arraycopy(batch, 0, smallBatch, 0, smallBatchSize);
                List results = this.loaders[i2].loadEntityBatch(session, smallBatch, this.persister().getIdentifierType(), optionalObject, this.persister().getEntityName(), id, this.persister(), lockOptions, readOnly);
                BatchFetchQueueHelper.removeNotFoundBatchLoadableEntityKeys(smallBatch, results, this.persister(), session);
                return this.getObjectFromList(results, id, session);
            }
            Object result = ((UniqueEntityLoader)((Object)this.loaders[this.batchSizes.length - 1])).load(id, optionalObject, session);
            if (result == null) {
                BatchFetchQueueHelper.removeBatchLoadableEntityKey(id, this.persister(), session);
            }
            return result;
        }
    }
}

