/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.service.internal;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.internal.DefaultAutoFlushEventListener;
import org.hibernate.event.internal.DefaultDeleteEventListener;
import org.hibernate.event.internal.DefaultDirtyCheckEventListener;
import org.hibernate.event.internal.DefaultEvictEventListener;
import org.hibernate.event.internal.DefaultFlushEntityEventListener;
import org.hibernate.event.internal.DefaultFlushEventListener;
import org.hibernate.event.internal.DefaultInitializeCollectionEventListener;
import org.hibernate.event.internal.DefaultLoadEventListener;
import org.hibernate.event.internal.DefaultLockEventListener;
import org.hibernate.event.internal.DefaultMergeEventListener;
import org.hibernate.event.internal.DefaultPersistEventListener;
import org.hibernate.event.internal.DefaultPersistOnFlushEventListener;
import org.hibernate.event.internal.DefaultPostLoadEventListener;
import org.hibernate.event.internal.DefaultPreLoadEventListener;
import org.hibernate.event.internal.DefaultRefreshEventListener;
import org.hibernate.event.internal.DefaultReplicateEventListener;
import org.hibernate.event.internal.DefaultResolveNaturalIdEventListener;
import org.hibernate.event.internal.DefaultSaveEventListener;
import org.hibernate.event.internal.DefaultSaveOrUpdateEventListener;
import org.hibernate.event.internal.DefaultUpdateEventListener;
import org.hibernate.event.internal.PostDeleteEventListenerStandardImpl;
import org.hibernate.event.internal.PostInsertEventListenerStandardImpl;
import org.hibernate.event.internal.PostUpdateEventListenerStandardImpl;
import org.hibernate.event.service.internal.EventListenerGroupImpl;
import org.hibernate.event.service.internal.PostCommitEventListenerGroupImpl;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistrationException;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.jpa.event.internal.CallbackRegistryImplementor;
import org.hibernate.jpa.event.internal.CallbacksFactory;
import org.hibernate.jpa.event.spi.CallbackBuilder;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;

public class EventListenerRegistryImpl
implements EventListenerRegistry,
Stoppable {
    private Map<Class, Object> listenerClassToInstanceMap = new HashMap<Class, Object>();
    private final SessionFactoryImplementor sessionFactory;
    private final CallbackRegistryImplementor callbackRegistry;
    private final EventListenerGroupImpl[] registeredEventListeners;
    private CallbackBuilder callbackBuilder;

    @Deprecated
    EventListenerRegistryImpl(SessionFactoryImplementor sessionFactory, SessionFactoryOptions sessionFactoryOptions, ServiceRegistryImplementor registry) {
        this.sessionFactory = sessionFactory;
        this.callbackRegistry = CallbacksFactory.buildCallbackRegistry(sessionFactory);
        this.registeredEventListeners = this.buildListenerGroups();
    }

    EventListenerRegistryImpl(BootstrapContext bootstrapContext, SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.callbackRegistry = CallbacksFactory.buildCallbackRegistry(sessionFactory);
        this.callbackBuilder = CallbacksFactory.buildCallbackBuilder(sessionFactory, bootstrapContext.getReflectionManager());
        this.registeredEventListeners = this.buildListenerGroups();
    }

    SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    CallbackRegistry getCallbackRegistry() {
        return this.callbackRegistry;
    }

    @Override
    public void prepare(MetadataImplementor metadata) {
        if (this.callbackBuilder == null) {
            this.callbackBuilder = CallbacksFactory.buildCallbackBuilder(this.sessionFactory, metadata.getMetadataBuildingOptions().getReflectionManager());
        }
        for (PersistentClass persistentClass : metadata.getEntityBindings()) {
            if (persistentClass.getClassName() == null) continue;
            this.callbackBuilder.buildCallbacksForEntity(persistentClass.getClassName(), this.callbackRegistry);
            Iterator propertyIterator = persistentClass.getDeclaredPropertyIterator();
            while (propertyIterator.hasNext()) {
                Property property = (Property)propertyIterator.next();
                if (!property.getType().isComponentType()) continue;
                this.callbackBuilder.buildCallbacksForEmbeddable(property, persistentClass.getClassName(), this.callbackRegistry);
            }
        }
    }

    public <T> EventListenerGroupImpl<T> getEventListenerGroup(EventType<T> eventType) {
        EventListenerGroupImpl listeners = this.registeredEventListeners[eventType.ordinal()];
        if (listeners == null) {
            throw new HibernateException("Unable to find listeners for type [" + eventType.eventName() + "]");
        }
        return listeners;
    }

    @Override
    public void addDuplicationStrategy(DuplicationStrategy strategy) {
        for (EventListenerGroupImpl group : this.registeredEventListeners) {
            if (group == null) continue;
            group.addDuplicationStrategy(strategy);
        }
    }

    @Override
    @SafeVarargs
    public final <T> void setListeners(EventType<T> type, Class<? extends T> ... listenerClasses) {
        this.setListeners(type, this.resolveListenerInstances(type, listenerClasses));
    }

    private <T> T[] resolveListenerInstances(EventType<T> type, Class<? extends T> ... listenerClasses) {
        Object[] listeners = (Object[])Array.newInstance(type.baseListenerInterface(), listenerClasses.length);
        for (int i2 = 0; i2 < listenerClasses.length; ++i2) {
            listeners[i2] = this.resolveListenerInstance(listenerClasses[i2]);
        }
        return listeners;
    }

    private <T> T resolveListenerInstance(Class<T> listenerClass) {
        Object listenerInstance = this.listenerClassToInstanceMap.get(listenerClass);
        if (listenerInstance == null) {
            listenerInstance = this.instantiateListener(listenerClass);
            this.listenerClassToInstanceMap.put(listenerClass, listenerInstance);
        }
        return (T)listenerInstance;
    }

    private <T> T instantiateListener(Class<T> listenerClass) {
        try {
            return listenerClass.newInstance();
        }
        catch (Exception e) {
            throw new EventListenerRegistrationException("Unable to instantiate specified event listener class: " + listenerClass.getName(), e);
        }
    }

    @Override
    @SafeVarargs
    public final <T> void setListeners(EventType<T> type, T ... listeners) {
        EventListenerGroup registeredListeners = this.getEventListenerGroup((EventType)type);
        ((EventListenerGroupImpl)registeredListeners).clear();
        if (listeners != null) {
            for (T listener : listeners) {
                ((EventListenerGroupImpl)registeredListeners).appendListener(listener);
            }
        }
    }

    @Override
    @SafeVarargs
    public final <T> void appendListeners(EventType<T> type, Class<? extends T> ... listenerClasses) {
        this.appendListeners(type, this.resolveListenerInstances(type, listenerClasses));
    }

    @Override
    @SafeVarargs
    public final <T> void appendListeners(EventType<T> type, T ... listeners) {
        ((EventListenerGroupImpl)this.getEventListenerGroup((EventType)type)).appendListeners(listeners);
    }

    @Override
    @SafeVarargs
    public final <T> void prependListeners(EventType<T> type, Class<? extends T> ... listenerClasses) {
        this.prependListeners(type, this.resolveListenerInstances(type, listenerClasses));
    }

    @Override
    @SafeVarargs
    public final <T> void prependListeners(EventType<T> type, T ... listeners) {
        ((EventListenerGroupImpl)this.getEventListenerGroup((EventType)type)).prependListeners(listeners);
    }

    private EventListenerGroupImpl[] buildListenerGroups() {
        EventListenerGroupImpl[] listenerArray = new EventListenerGroupImpl[EventType.values().size()];
        this.prepareListeners(EventType.AUTO_FLUSH, new DefaultAutoFlushEventListener(), listenerArray);
        this.prepareListeners(EventType.PERSIST, new DefaultPersistEventListener(), listenerArray);
        this.prepareListeners(EventType.PERSIST_ONFLUSH, new DefaultPersistOnFlushEventListener(), listenerArray);
        this.prepareListeners(EventType.DELETE, new DefaultDeleteEventListener(), listenerArray);
        this.prepareListeners(EventType.DIRTY_CHECK, new DefaultDirtyCheckEventListener(), listenerArray);
        this.prepareListeners(EventType.EVICT, new DefaultEvictEventListener(), listenerArray);
        this.prepareListeners(EventType.CLEAR, listenerArray);
        this.prepareListeners(EventType.FLUSH, new DefaultFlushEventListener(), listenerArray);
        this.prepareListeners(EventType.FLUSH_ENTITY, new DefaultFlushEntityEventListener(), listenerArray);
        this.prepareListeners(EventType.LOAD, new DefaultLoadEventListener(), listenerArray);
        this.prepareListeners(EventType.RESOLVE_NATURAL_ID, new DefaultResolveNaturalIdEventListener(), listenerArray);
        this.prepareListeners(EventType.INIT_COLLECTION, new DefaultInitializeCollectionEventListener(), listenerArray);
        this.prepareListeners(EventType.LOCK, new DefaultLockEventListener(), listenerArray);
        this.prepareListeners(EventType.MERGE, new DefaultMergeEventListener(), listenerArray);
        this.prepareListeners(EventType.PRE_COLLECTION_RECREATE, listenerArray);
        this.prepareListeners(EventType.PRE_COLLECTION_REMOVE, listenerArray);
        this.prepareListeners(EventType.PRE_COLLECTION_UPDATE, listenerArray);
        this.prepareListeners(EventType.PRE_DELETE, listenerArray);
        this.prepareListeners(EventType.PRE_INSERT, listenerArray);
        this.prepareListeners(EventType.PRE_LOAD, new DefaultPreLoadEventListener(), listenerArray);
        this.prepareListeners(EventType.PRE_UPDATE, listenerArray);
        this.prepareListeners(EventType.POST_COLLECTION_RECREATE, listenerArray);
        this.prepareListeners(EventType.POST_COLLECTION_REMOVE, listenerArray);
        this.prepareListeners(EventType.POST_COLLECTION_UPDATE, listenerArray);
        this.prepareListeners(EventType.POST_COMMIT_DELETE, listenerArray);
        this.prepareListeners(EventType.POST_COMMIT_INSERT, listenerArray);
        this.prepareListeners(EventType.POST_COMMIT_UPDATE, listenerArray);
        this.prepareListeners(EventType.POST_DELETE, new PostDeleteEventListenerStandardImpl(), listenerArray);
        this.prepareListeners(EventType.POST_INSERT, new PostInsertEventListenerStandardImpl(), listenerArray);
        this.prepareListeners(EventType.POST_LOAD, new DefaultPostLoadEventListener(), listenerArray);
        this.prepareListeners(EventType.POST_UPDATE, new PostUpdateEventListenerStandardImpl(), listenerArray);
        this.prepareListeners(EventType.UPDATE, new DefaultUpdateEventListener(), listenerArray);
        this.prepareListeners(EventType.REFRESH, new DefaultRefreshEventListener(), listenerArray);
        this.prepareListeners(EventType.REPLICATE, new DefaultReplicateEventListener(), listenerArray);
        this.prepareListeners(EventType.SAVE, new DefaultSaveEventListener(), listenerArray);
        this.prepareListeners(EventType.SAVE_UPDATE, new DefaultSaveOrUpdateEventListener(), listenerArray);
        return listenerArray;
    }

    private <T> void prepareListeners(EventType<T> type, EventListenerGroupImpl[] listenerArray) {
        this.prepareListeners(type, null, listenerArray);
    }

    private <T> void prepareListeners(EventType<T> type, T defaultListener, EventListenerGroupImpl[] listenerArray) {
        EventListenerGroupImpl listenerGroup = type == EventType.POST_COMMIT_DELETE || type == EventType.POST_COMMIT_INSERT || type == EventType.POST_COMMIT_UPDATE ? new PostCommitEventListenerGroupImpl<T>(type, this) : new EventListenerGroupImpl<T>(type, this);
        if (defaultListener != null) {
            ((EventListenerGroupImpl)listenerGroup).appendListener(defaultListener);
        }
        listenerArray[type.ordinal()] = listenerGroup;
    }

    @Override
    public void stop() {
        if (this.callbackRegistry != null) {
            this.callbackRegistry.release();
        }
        if (this.callbackBuilder != null) {
            this.callbackBuilder.release();
        }
    }
}

