/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.event.internal.AbstractVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.type.CollectionType;

public class DirtyCollectionSearchVisitor
extends AbstractVisitor {
    private boolean dirty;
    private boolean[] propertyVersionability;

    public DirtyCollectionSearchVisitor(EventSource session, boolean[] propertyVersionability) {
        super(session);
        this.propertyVersionability = propertyVersionability;
    }

    public boolean wasDirtyCollectionFound() {
        return this.dirty;
    }

    @Override
    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection != null) {
            EventSource session = this.getSession();
            PersistentCollection persistentCollection = type.isArrayType() ? session.getPersistenceContextInternal().getCollectionHolder(collection) : (PersistentCollection)collection;
            if (persistentCollection.isDirty()) {
                this.dirty = true;
                return null;
            }
        }
        return null;
    }

    @Override
    boolean includeEntityProperty(Object[] values, int i2) {
        return this.propertyVersionability[i2] && super.includeEntityProperty(values, i2);
    }
}

