/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class PersistentArrayHolder
extends AbstractPersistentCollection {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, PersistentArrayHolder.class.getName());
    protected Object array;
    private transient Class elementClass;
    private transient List tempList;

    public PersistentArrayHolder(SharedSessionContractImplementor session, Object array) {
        super(session);
        this.array = array;
        this.setInitialized();
    }

    @Deprecated
    public PersistentArrayHolder(SessionImplementor session, Object array) {
        this((SharedSessionContractImplementor)session, array);
    }

    public PersistentArrayHolder(SharedSessionContractImplementor session, CollectionPersister persister) {
        super(session);
        this.elementClass = persister.getElementClass();
    }

    @Deprecated
    public PersistentArrayHolder(SessionImplementor session, CollectionPersister persister) {
        this((SharedSessionContractImplementor)session, persister);
    }

    @Override
    public Serializable getSnapshot(CollectionPersister persister) throws HibernateException {
        int length = Array.getLength(this.array);
        Serializable result = (Serializable)Array.newInstance(persister.getElementClass(), length);
        for (int i2 = 0; i2 < length; ++i2) {
            Object elt = Array.get(this.array, i2);
            try {
                Array.set(result, i2, persister.getElementType().deepCopy(elt, persister.getFactory()));
                continue;
            }
            catch (IllegalArgumentException iae) {
                LOG.invalidArrayElementType(iae.getMessage());
                throw new HibernateException("Array element type error", iae);
            }
        }
        return result;
    }

    @Override
    public boolean isSnapshotEmpty(Serializable snapshot) {
        return Array.getLength(snapshot) == 0;
    }

    @Override
    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        Object[] sn = (Object[])snapshot;
        Object[] arr = (Object[])this.array;
        ArrayList result = new ArrayList();
        Collections.addAll(result, sn);
        for (int i2 = 0; i2 < sn.length; ++i2) {
            PersistentArrayHolder.identityRemove(result, arr[i2], entityName, this.getSession());
        }
        return result;
    }

    public Object getArray() {
        return this.array;
    }

    @Override
    public boolean isWrapper(Object collection) {
        return this.array == collection;
    }

    @Override
    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        Serializable snapshot = this.getSnapshot();
        int xlen = Array.getLength(snapshot);
        if (xlen != Array.getLength(this.array)) {
            return false;
        }
        for (int i2 = 0; i2 < xlen; ++i2) {
            if (!elementType.isDirty(Array.get(snapshot, i2), Array.get(this.array, i2), this.getSession())) continue;
            return false;
        }
        return true;
    }

    public Iterator elements() {
        int length = Array.getLength(this.array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i2 = 0; i2 < length; ++i2) {
            list.add(Array.get(this.array, i2));
        }
        return list.iterator();
    }

    @Override
    public boolean empty() {
        return false;
    }

    @Override
    public Object readFrom(ResultSet rs, CollectionPersister persister, CollectionAliases descriptor, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, descriptor.getSuffixedElementAliases(), this.getSession());
        int index = (Integer)persister.readIndex(rs, descriptor.getSuffixedIndexAliases(), this.getSession());
        for (int i2 = this.tempList.size(); i2 <= index; ++i2) {
            this.tempList.add(i2, null);
        }
        this.tempList.set(index, element);
        return element;
    }

    @Override
    public Iterator entries(CollectionPersister persister) {
        return this.elements();
    }

    @Override
    public void beginRead() {
        super.beginRead();
        this.tempList = new ArrayList();
    }

    @Override
    public boolean endRead() {
        this.setInitialized();
        this.array = Array.newInstance(this.elementClass, this.tempList.size());
        for (int i2 = 0; i2 < this.tempList.size(); ++i2) {
            Array.set(this.array, i2, this.tempList.get(i2));
        }
        this.tempList = null;
        return true;
    }

    @Override
    public void beforeInitialize(CollectionPersister persister, int anticipatedSize) {
    }

    @Override
    public boolean isDirectlyAccessible() {
        return true;
    }

    @Override
    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        Serializable[] cached = (Serializable[])disassembled;
        this.array = Array.newInstance(persister.getElementClass(), cached.length);
        for (int i2 = 0; i2 < cached.length; ++i2) {
            Array.set(this.array, i2, persister.getElementType().assemble(cached[i2], this.getSession(), owner));
        }
    }

    @Override
    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = Array.getLength(this.array);
        Serializable[] result = new Serializable[length];
        for (int i2 = 0; i2 < length; ++i2) {
            result[i2] = persister.getElementType().disassemble(Array.get(this.array, i2), this.getSession(), null);
        }
        return result;
    }

    @Override
    public Object getValue() {
        return this.array;
    }

    @Override
    public Iterator getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        int end;
        int i2;
        int arraySize;
        ArrayList<Integer> deletes = new ArrayList<Integer>();
        Serializable sn = this.getSnapshot();
        int snSize = Array.getLength(sn);
        if (snSize > (arraySize = Array.getLength(this.array))) {
            for (i2 = arraySize; i2 < snSize; ++i2) {
                deletes.add(i2);
            }
            end = arraySize;
        } else {
            end = snSize;
        }
        for (i2 = 0; i2 < end; ++i2) {
            if (Array.get(this.array, i2) != null || Array.get(sn, i2) == null) continue;
            deletes.add(i2);
        }
        return deletes.iterator();
    }

    @Override
    public boolean needsInserting(Object entry, int i2, Type elemType) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return Array.get(this.array, i2) != null && (i2 >= Array.getLength(sn) || Array.get(sn, i2) == null);
    }

    @Override
    public boolean needsUpdating(Object entry, int i2, Type elemType) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return i2 < Array.getLength(sn) && Array.get(sn, i2) != null && Array.get(this.array, i2) != null && elemType.isDirty(Array.get(this.array, i2), Array.get(sn, i2), this.getSession());
    }

    @Override
    public Object getIndex(Object entry, int i2, CollectionPersister persister) {
        return i2;
    }

    @Override
    public Object getElement(Object entry) {
        return entry;
    }

    @Override
    public Object getSnapshotElement(Object entry, int i2) {
        Serializable sn = this.getSnapshot();
        return Array.get(sn, i2);
    }

    @Override
    public boolean entryExists(Object entry, int i2) {
        return entry != null;
    }
}

