/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Callable;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveBoxingDelegate;
import net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveUnboxingDelegate;
import net.bytebuddy.implementation.bytecode.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerImpl;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.internal.bytebuddy.BulkAccessorException;
import org.hibernate.bytecode.internal.bytebuddy.ByteBuddyState;
import org.hibernate.bytecode.internal.bytebuddy.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.internal.bytebuddy.ReflectionOptimizerImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyProxyHelper;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private static final String INSTANTIATOR_PROXY_NAMING_SUFFIX = "HibernateInstantiator";
    private static final String OPTIMIZER_PROXY_NAMING_SUFFIX = "HibernateAccessOptimizer";
    private static final ElementMatcher.Junction newInstanceMethodName = ElementMatchers.named("newInstance");
    private static final ElementMatcher.Junction getPropertyValuesMethodName = ElementMatchers.named("getPropertyValues");
    private static final ElementMatcher.Junction setPropertyValuesMethodName = ElementMatchers.named("setPropertyValues");
    private static final ElementMatcher.Junction getPropertyNamesMethodName = ElementMatchers.named("getPropertyNames");
    private final ByteBuddyState byteBuddyState = new ByteBuddyState();
    private final ByteBuddyProxyHelper byteBuddyProxyHelper = new ByteBuddyProxyHelper(this.byteBuddyState);

    @Override
    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl(this.byteBuddyState, this.byteBuddyProxyHelper);
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        Class<?> fastClass;
        if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            Constructor<?> constructor = BytecodeProviderImpl.findConstructor(clazz);
            fastClass = this.byteBuddyState.load(clazz, byteBuddy -> byteBuddy.with(new NamingStrategy.SuffixingRandom(INSTANTIATOR_PROXY_NAMING_SUFFIX, new NamingStrategy.SuffixingRandom.BaseNameResolver.ForFixedValue(clazz.getName()))).subclass(ReflectionOptimizer.InstantiationOptimizer.class).method(newInstanceMethodName).intercept(MethodCall.construct(constructor)));
        } else {
            fastClass = null;
        }
        Method[] getters = new Method[getterNames.length];
        Method[] setters = new Method[setterNames.length];
        BytecodeProviderImpl.findAccessors(clazz, getterNames, setterNames, types, getters, setters);
        Class<?> bulkAccessor = this.byteBuddyState.load(clazz, byteBuddy -> byteBuddy.with(new NamingStrategy.SuffixingRandom(OPTIMIZER_PROXY_NAMING_SUFFIX, new NamingStrategy.SuffixingRandom.BaseNameResolver.ForFixedValue(clazz.getName()))).subclass(ReflectionOptimizer.AccessOptimizer.class).method(getPropertyValuesMethodName).intercept(new Implementation.Simple(new GetPropertyValues(clazz, getters))).method(setPropertyValuesMethodName).intercept(new Implementation.Simple(new SetPropertyValues(clazz, setters))).method(getPropertyNamesMethodName).intercept(MethodCall.call(new CloningPropertyCall(getterNames))));
        try {
            return new ReflectionOptimizerImpl(fastClass != null ? (ReflectionOptimizer.InstantiationOptimizer)fastClass.newInstance() : null, (ReflectionOptimizer.AccessOptimizer)bulkAccessor.newInstance());
        }
        catch (Exception exception) {
            throw new HibernateException(exception);
        }
    }

    public ByteBuddyProxyHelper getByteBuddyProxyHelper() {
        return this.byteBuddyProxyHelper;
    }

    private static void findAccessors(Class clazz, String[] getterNames, String[] setterNames, Class[] types, Method[] getters, Method[] setters) {
        int length = types.length;
        if (setterNames.length != length || getterNames.length != length) {
            throw new BulkAccessorException("bad number of accessors");
        }
        Class[] getParam = new Class[]{};
        Class[] setParam = new Class[1];
        for (int i2 = 0; i2 < length; ++i2) {
            if (getterNames[i2] != null) {
                Method getter = BytecodeProviderImpl.findAccessor(clazz, getterNames[i2], getParam, i2);
                if (getter.getReturnType() != types[i2]) {
                    throw new BulkAccessorException("wrong return type: " + getterNames[i2], i2);
                }
                getters[i2] = getter;
            }
            if (setterNames[i2] == null) continue;
            setParam[0] = types[i2];
            setters[i2] = BytecodeProviderImpl.findAccessor(clazz, setterNames[i2], setParam, i2);
        }
    }

    private static Method findAccessor(Class clazz, String name, Class[] params, int index) throws BulkAccessorException {
        try {
            Method method = clazz.getDeclaredMethod(name, params);
            if (Modifier.isPrivate(method.getModifiers())) {
                throw new BulkAccessorException("private property", index);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new BulkAccessorException("cannot find an accessor", index);
        }
    }

    private static Constructor<?> findConstructor(Class clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException(e);
        }
    }

    @Override
    public Enhancer getEnhancer(EnhancementContext enhancementContext) {
        return new EnhancerImpl(enhancementContext, this.byteBuddyState);
    }

    @Override
    public void resetCaches() {
        this.byteBuddyState.clearState();
    }

    public static class CloningPropertyCall
    implements Callable<String[]> {
        private final String[] propertyNames;

        private CloningPropertyCall(String[] propertyNames) {
            this.propertyNames = propertyNames;
        }

        @Override
        public String[] call() {
            return (String[])this.propertyNames.clone();
        }
    }

    private static class SetPropertyValues
    implements ByteCodeAppender {
        private final Class clazz;
        private final Method[] setters;

        public SetPropertyValues(Class clazz, Method[] setters) {
            this.clazz = clazz;
            this.setters = setters;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            int index = 0;
            for (Method setter : this.setters) {
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(this.clazz));
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitLdcInsn(index++);
                methodVisitor.visitInsn(50);
                if (setter.getParameterTypes()[0].isPrimitive()) {
                    PrimitiveUnboxingDelegate.forReferenceType(TypeDescription.Generic.OBJECT).assignUnboxedTo(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(setter.getParameterTypes()[0]), ReferenceTypeAwareAssigner.INSTANCE, Assigner.Typing.DYNAMIC).apply(methodVisitor, implementationContext);
                } else {
                    methodVisitor.visitTypeInsn(192, Type.getInternalName(setter.getParameterTypes()[0]));
                }
                methodVisitor.visitMethodInsn(182, Type.getInternalName(this.clazz), setter.getName(), Type.getMethodDescriptor(setter), false);
            }
            methodVisitor.visitInsn(177);
            return new ByteCodeAppender.Size(4, instrumentedMethod.getStackSize());
        }
    }

    private static class GetPropertyValues
    implements ByteCodeAppender {
        private final Class clazz;
        private final Method[] getters;

        public GetPropertyValues(Class clazz, Method[] getters) {
            this.clazz = clazz;
            this.getters = getters;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            methodVisitor.visitLdcInsn(this.getters.length);
            methodVisitor.visitTypeInsn(189, Type.getInternalName(Object.class));
            int index = 0;
            for (Method getter : this.getters) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn(index++);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(this.clazz));
                methodVisitor.visitMethodInsn(182, Type.getInternalName(this.clazz), getter.getName(), Type.getMethodDescriptor(getter), false);
                if (getter.getReturnType().isPrimitive()) {
                    PrimitiveBoxingDelegate.forPrimitive(new TypeDescription.ForLoadedType(getter.getReturnType())).assignBoxedTo(TypeDescription.Generic.OBJECT, ReferenceTypeAwareAssigner.INSTANCE, Assigner.Typing.STATIC).apply(methodVisitor, implementationContext);
                }
                methodVisitor.visitInsn(83);
            }
            methodVisitor.visitInsn(176);
            return new ByteCodeAppender.Size(6, instrumentedMethod.getStackSize());
        }
    }
}

