/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.javassist;

import javassist.CtClass;
import javassist.CtField;
import org.hibernate.bytecode.enhance.internal.javassist.UnloadedCtClass;
import org.hibernate.bytecode.enhance.internal.javassist.UnloadedCtField;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.UnloadedField;

public class JavassistEnhancementContext {
    private final EnhancementContext enhancementContext;

    public JavassistEnhancementContext(EnhancementContext enhancementContext) {
        this.enhancementContext = enhancementContext;
    }

    public ClassLoader getLoadingClassLoader() {
        return this.enhancementContext.getLoadingClassLoader();
    }

    public boolean isEntityClass(CtClass classDescriptor) {
        return this.enhancementContext.isEntityClass(new UnloadedCtClass(classDescriptor));
    }

    public boolean isCompositeClass(CtClass classDescriptor) {
        return this.enhancementContext.isCompositeClass(new UnloadedCtClass(classDescriptor));
    }

    public boolean isMappedSuperclassClass(CtClass classDescriptor) {
        return this.enhancementContext.isMappedSuperclassClass(new UnloadedCtClass(classDescriptor));
    }

    public boolean doBiDirectionalAssociationManagement(CtField field) {
        return this.enhancementContext.doBiDirectionalAssociationManagement(new UnloadedCtField(field));
    }

    public boolean doDirtyCheckingInline(CtClass classDescriptor) {
        return this.enhancementContext.doDirtyCheckingInline(new UnloadedCtClass(classDescriptor));
    }

    public boolean doExtendedEnhancement(CtClass classDescriptor) {
        return this.enhancementContext.doExtendedEnhancement(new UnloadedCtClass(classDescriptor));
    }

    public boolean hasLazyLoadableAttributes(CtClass classDescriptor) {
        return this.enhancementContext.hasLazyLoadableAttributes(new UnloadedCtClass(classDescriptor));
    }

    public boolean isPersistentField(CtField ctField) {
        return this.enhancementContext.isPersistentField(new UnloadedCtField(ctField));
    }

    public CtField[] order(CtField[] persistentFields) {
        UnloadedField[] unloadedFields = new UnloadedField[persistentFields.length];
        for (int i2 = 0; i2 < unloadedFields.length; ++i2) {
            unloadedFields[i2] = new UnloadedCtField(persistentFields[i2]);
        }
        UnloadedField[] ordered = this.enhancementContext.order(unloadedFields);
        CtField[] orderedFields = new CtField[persistentFields.length];
        for (int i3 = 0; i3 < orderedFields.length; ++i3) {
            orderedFields[i3] = ((UnloadedCtField)ordered[i3]).ctField;
        }
        return orderedFields;
    }

    public boolean isLazyLoadable(CtField field) {
        return this.enhancementContext.isLazyLoadable(new UnloadedCtField(field));
    }

    public boolean isMappedCollection(CtField field) {
        return this.enhancementContext.isMappedCollection(new UnloadedCtField(field));
    }
}

