/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.util.ArrayList;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.patterns.BasicToken;
import org.aspectj.weaver.patterns.IToken;
import org.aspectj.weaver.patterns.ITokenSource;

public class BasicTokenSource
implements ITokenSource {
    private int index = 0;
    private IToken[] tokens;
    private ISourceContext sourceContext;

    public BasicTokenSource(IToken[] tokens, ISourceContext sourceContext) {
        this.tokens = tokens;
        this.sourceContext = sourceContext;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int newIndex) {
        this.index = newIndex;
    }

    @Override
    public IToken next() {
        try {
            return this.tokens[this.index++];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return IToken.EOF;
        }
    }

    @Override
    public IToken peek() {
        try {
            return this.tokens[this.index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return IToken.EOF;
        }
    }

    @Override
    public IToken peek(int offset) {
        try {
            return this.tokens[this.index + offset];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return IToken.EOF;
        }
    }

    public String toString() {
        IToken t;
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i2 = 0; i2 < this.tokens.length && (t = this.tokens[i2]) != null; ++i2) {
            if (i2 > 0) {
                buf.append(", ");
            }
            buf.append(t.toString());
        }
        buf.append("]");
        return buf.toString();
    }

    public static ITokenSource makeTokenSource(String input, ISourceContext context) {
        char[] chars = input.toCharArray();
        int i2 = 0;
        ArrayList<BasicToken> tokens = new ArrayList<BasicToken>();
        block8: while (i2 < chars.length) {
            char ch = chars[i2++];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block8;
                }
                case '!': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': {
                    tokens.add(BasicToken.makeOperator(BasicTokenSource.makeString(ch), i2 - 1, i2 - 1));
                    continue block8;
                }
                case '.': {
                    if (i2 + 2 <= chars.length) {
                        char nextChar1 = chars[i2];
                        char nextChar2 = chars[i2 + 1];
                        if (ch == nextChar1 && ch == nextChar2) {
                            tokens.add(BasicToken.makeIdentifier("...", i2 - 1, i2 + 1));
                            i2 += 2;
                            continue block8;
                        }
                        tokens.add(BasicToken.makeOperator(BasicTokenSource.makeString(ch), i2 - 1, i2 - 1));
                        continue block8;
                    }
                    tokens.add(BasicToken.makeOperator(BasicTokenSource.makeString(ch), i2 - 1, i2 - 1));
                    continue block8;
                }
                case '&': {
                    if (i2 + 1 <= chars.length && chars[i2] != '&') {
                        tokens.add(BasicToken.makeOperator(BasicTokenSource.makeString(ch), i2 - 1, i2 - 1));
                        continue block8;
                    }
                }
                case '|': {
                    char nextChar;
                    if (i2 == chars.length) {
                        throw new BCException("bad " + ch);
                    }
                    if ((nextChar = chars[i2++]) == ch) {
                        tokens.add(BasicToken.makeOperator(BasicTokenSource.makeString(ch, 2), i2 - 2, i2 - 1));
                        continue block8;
                    }
                    throw new RuntimeException("bad " + ch);
                }
                case '\"': {
                    int start0 = i2 - 1;
                    while (i2 < chars.length && chars[i2] != '\"') {
                        ++i2;
                    }
                    tokens.add(BasicToken.makeLiteral(new String(chars, start0 + 1, ++i2 - start0 - 2), "string", start0, i2 - 1));
                    continue block8;
                }
            }
            int start = i2 - 1;
            while (i2 < chars.length && Character.isJavaIdentifierPart(chars[i2])) {
                ++i2;
            }
            tokens.add(BasicToken.makeIdentifier(new String(chars, start, i2 - start), start, i2 - 1));
        }
        return new BasicTokenSource(tokens.toArray(new IToken[tokens.size()]), context);
    }

    private static String makeString(char ch) {
        return Character.toString(ch);
    }

    private static String makeString(char ch, int count) {
        char[] chars = new char[count];
        for (int i2 = 0; i2 < count; ++i2) {
            chars[i2] = ch;
        }
        return new String(chars);
    }

    @Override
    public ISourceContext getSourceContext() {
        return this.sourceContext;
    }

    public void setSourceContext(ISourceContext context) {
        this.sourceContext = context;
    }

    @Override
    public boolean hasMoreTokens() {
        return this.index < this.tokens.length;
    }
}

