/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.face.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections.MapUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.springframework.web.multipart.MultipartFile;

public class HttpClient {
    private String url;
    private Map<String, String> param;
    private int statusCode;
    private String content;
    private String xmlParam;
    private boolean isHttps;

    public boolean isHttps() {
        return this.isHttps;
    }

    public void setHttps(boolean isHttps) {
        this.isHttps = isHttps;
    }

    public String getXmlParam() {
        return this.xmlParam;
    }

    public void setXmlParam(String xmlParam) {
        this.xmlParam = xmlParam;
    }

    public HttpClient(String url, Map<String, String> param) {
        this.url = url;
        this.param = param;
    }

    public HttpClient(String url) {
        this.url = url;
    }

    public void setParameter(Map<String, String> map) {
        this.param = map;
    }

    public void addParameter(String key, String value) {
        if (this.param == null) {
            this.param = new HashMap();
        }
        this.param.put(key, value);
    }

    public void post() throws ClientProtocolException, IOException {
        HttpPost http = new HttpPost(this.url);
        this.setEntity((HttpEntityEnclosingRequestBase)http);
        this.execute((HttpUriRequest)http);
    }

    public void put() throws ClientProtocolException, IOException {
        HttpPut http = new HttpPut(this.url);
        this.setEntity((HttpEntityEnclosingRequestBase)http);
        this.execute((HttpUriRequest)http);
    }

    public void get() throws ClientProtocolException, IOException {
        if (this.param != null) {
            StringBuilder url = new StringBuilder(this.url);
            boolean isFirst = true;
            for (String key : this.param.keySet()) {
                if (isFirst) {
                    url.append("?");
                } else {
                    url.append("&");
                }
                url.append(key).append("=").append((String)this.param.get(key));
            }
            this.url = url.toString();
        }
        HttpGet http = new HttpGet(this.url);
        this.execute((HttpUriRequest)http);
    }

    private void setEntity(HttpEntityEnclosingRequestBase http) {
        if (this.param != null) {
            LinkedList<BasicNameValuePair> nvps = new LinkedList<BasicNameValuePair>();
            for (String key : this.param.keySet()) {
                nvps.add(new BasicNameValuePair(key, (String)this.param.get(key)));
            }
            http.setEntity(new UrlEncodedFormEntity(nvps, Consts.UTF_8));
        }
        if (this.xmlParam != null) {
            http.setEntity(new StringEntity(this.xmlParam, Consts.UTF_8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(HttpUriRequest http) throws ClientProtocolException, IOException {
        try (Closeable httpClient = null;){
            if (this.isHttps) {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new /* Unavailable Anonymous Inner Class!! */).build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
                httpClient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
            } else {
                httpClient = HttpClients.createDefault();
            }
            try (CloseableHttpResponse response = ((CloseableHttpClient)httpClient).execute(http);){
                if (response != null) {
                    if (response.getStatusLine() != null) {
                        this.statusCode = response.getStatusLine().getStatusCode();
                    }
                    HttpEntity entity = response.getEntity();
                    this.content = EntityUtils.toString(entity, Consts.UTF_8);
                }
            }
        }
    }

    public static String httpClientPostSetBody(String url, Map<String, String> parmaMap1) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String result = "";
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        ContentType contentType = ContentType.create("text/plain", "UTF-8");
        builder.setCharset(Charset.forName("utf-8"));
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.setCharset(StandardCharsets.UTF_8);
        if (MapUtils.isNotEmpty(parmaMap1)) {
            for (Map.Entry<String, String> entry : parmaMap1.entrySet()) {
                System.out.println(entry.getKey());
                System.out.println(entry.getValue());
                builder.addTextBody(entry.getKey(), entry.getValue(), contentType);
                System.out.println("\u6b63\u5728\u5faa\u73af");
            }
        }
        System.out.println(builder.toString());
        HttpEntity entity = builder.build();
        httpPost.setEntity(entity);
        CloseableHttpResponse response = httpClient.execute(httpPost);
        HttpEntity responseEntity = response.getEntity();
        if (responseEntity != null) {
            result = EntityUtils.toString(responseEntity, StandardCharsets.UTF_8);
        }
        httpClient.close();
        return result;
    }

    public static String httpClientUploadFilePut(String url, Map<String, String> parma1) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String result = "";
        HttpPut httpPut = new HttpPut(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        ContentType contentType = ContentType.create("text/plain", "UTF-8");
        builder.setCharset(Charset.forName("utf-8"));
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.setCharset(StandardCharsets.UTF_8);
        System.out.println("\u83b7\u53d6\u6587\u4ef6\u6210\u529f");
        System.out.println("name=" + parma1.get("name"));
        builder.addTextBody("id", parma1.get("id"), contentType);
        builder.addTextBody("name", parma1.get("name"), contentType);
        builder.addTextBody("mark", parma1.get("mark"), contentType);
        System.out.println(builder.toString());
        HttpEntity entity = builder.build();
        httpPut.setEntity(entity);
        CloseableHttpResponse response = httpClient.execute(httpPut);
        HttpEntity responseEntity = response.getEntity();
        if (responseEntity != null) {
            result = EntityUtils.toString(responseEntity, StandardCharsets.UTF_8);
        }
        httpClient.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doDelete(String url) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpDelete httpDelete = new HttpDelete(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
        httpDelete.setConfig(requestConfig);
        httpDelete.setHeader("Content-type", "application/json");
        httpDelete.setHeader("DataEncoding", "UTF-8");
        CloseableHttpResponse httpResponse = null;
        try {
            String result;
            httpResponse = httpClient.execute(httpDelete);
            HttpEntity entity = httpResponse.getEntity();
            String string = result = EntityUtils.toString(entity);
            return string;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpClientUploadFilePost(String url, MultipartFile file, Map<String, String> header, Map<String, String> parma1) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String result = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (MapUtils.isNotEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            System.out.println("jinlai");
            ContentType contentType = ContentType.create("text/plain", "UTF-8");
            builder.setCharset(Charset.forName("utf-8"));
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addBinaryBody(file.getName(), file.getInputStream(), ContentType.MULTIPART_FORM_DATA, file.getName());
            System.out.println("\u83b7\u53d6\u6587\u4ef6\u6210\u529f");
            String group_id = parma1.get("group_id");
            String name = parma1.get("name");
            String idcard = parma1.get("idcard");
            System.out.println("name=" + parma1.get("name"));
            builder.addTextBody("group_id", group_id);
            builder.addTextBody("name", parma1.get("name"), contentType);
            builder.addTextBody("idcard", idcard);
            System.out.println(builder.toString());
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute(httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                result = EntityUtils.toString(responseEntity, StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            System.out.println("baocuo");
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                System.out.println("baocu");
            }
        }
        return result;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContent() throws ParseException, IOException {
        return this.content;
    }
}

