/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.deserializer.ContextObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateDeserializer
extends ContextObjectDeserializer
implements ObjectDeserializer {
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        return this.deserialze(parser, clazz, fieldName, null, 0);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName, String format, int features) {
        Object val2;
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 2) {
            val2 = lexer.longValue();
            lexer.nextToken(16);
        } else if (lexer.token() == 4) {
            String strVal = lexer.stringVal();
            if (format != null) {
                SimpleDateFormat simpleDateFormat;
                block37: {
                    simpleDateFormat = null;
                    try {
                        simpleDateFormat = new SimpleDateFormat(format, JSON.defaultLocale);
                    }
                    catch (IllegalArgumentException ex) {
                        if (format.equals("yyyy-MM-ddTHH:mm:ss.SSS")) {
                            format = "yyyy-MM-dd'T'HH:mm:ss.SSS";
                            simpleDateFormat = new SimpleDateFormat(format, JSON.defaultLocale);
                        }
                        if (!format.equals("yyyy-MM-ddTHH:mm:ss")) break block37;
                        format = "yyyy-MM-dd'T'HH:mm:ss";
                        simpleDateFormat = new SimpleDateFormat(format, JSON.defaultLocale);
                    }
                }
                if (JSON.defaultTimeZone != null) {
                    simpleDateFormat.setTimeZone(JSON.defaultTimeZone);
                }
                try {
                    val2 = simpleDateFormat.parse(strVal);
                }
                catch (ParseException ex) {
                    val2 = null;
                }
                if (val2 == null && JSON.defaultLocale == Locale.CHINA) {
                    simpleDateFormat = new SimpleDateFormat(format, Locale.US);
                    try {
                        val2 = simpleDateFormat.parse(strVal);
                    }
                    catch (ParseException ex) {
                        val2 = null;
                    }
                }
                if (val2 == null) {
                    if (format.equals("yyyy-MM-dd'T'HH:mm:ss.SSS") && strVal.length() == 19) {
                        try {
                            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", JSON.defaultLocale);
                            df.setTimeZone(JSON.defaultTimeZone);
                            val2 = df.parse(strVal);
                        }
                        catch (ParseException ex2) {
                            val2 = null;
                        }
                    } else {
                        val2 = null;
                    }
                }
            } else {
                val2 = null;
            }
            if (val2 == null) {
                val2 = strVal;
                lexer.nextToken(16);
                if (lexer.isEnabled(Feature.AllowISO8601DateFormat)) {
                    JSONScanner iso8601Lexer = new JSONScanner(strVal);
                    if (iso8601Lexer.scanISO8601DateIfMatch()) {
                        val2 = iso8601Lexer.getCalendar().getTime();
                    }
                    iso8601Lexer.close();
                }
            }
        } else if (lexer.token() == 8) {
            lexer.nextToken();
            val2 = null;
        } else if (lexer.token() == 12) {
            lexer.nextToken();
            if (lexer.token() == 4) {
                String key = lexer.stringVal();
                if (JSON.DEFAULT_TYPE_KEY.equals(key)) {
                    lexer.nextToken();
                    parser.accept(17);
                    String typeName = lexer.stringVal();
                    Class<?> type = parser.getConfig().checkAutoType(typeName, null, lexer.getFeatures());
                    if (type != null) {
                        clazz = type;
                    }
                    parser.accept(4);
                    parser.accept(16);
                }
            } else {
                throw new JSONException("syntax error");
            }
            lexer.nextTokenWithColon(2);
            if (lexer.token() != 2) {
                throw new JSONException("syntax error : " + lexer.tokenName());
            }
            long timeMillis = lexer.longValue();
            lexer.nextToken();
            val2 = timeMillis;
            parser.accept(13);
        } else if (parser.getResolveStatus() == 2) {
            parser.setResolveStatus(0);
            parser.accept(16);
            if (lexer.token() == 4) {
                if (!"val".equals(lexer.stringVal())) {
                    throw new JSONException("syntax error");
                }
            } else {
                throw new JSONException("syntax error");
            }
            lexer.nextToken();
            parser.accept(17);
            val2 = parser.parse();
            parser.accept(13);
        } else {
            val2 = parser.parse();
        }
        return this.cast(parser, clazz, fieldName, val2);
    }

    protected abstract <T> T cast(DefaultJSONParser var1, Type var2, Object var3, Object var4);
}

