/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.artemis.sdk.util;

import com.hikvision.artemis.sdk.Response;
import com.hikvision.artemis.sdk.constant.Constants;
import com.hikvision.artemis.sdk.util.MessageDigestUtil;
import com.hikvision.artemis.sdk.util.SignUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;

public class HttpUtil {
    private static final int MAX_TOTAL_CONNECTIONS = 300;
    private static final int DEFAULT_MAX_PER_ROUTE = 50;
    private static Map<String, RequestConfig> configMap = new ConcurrentHashMap<String, RequestConfig>(2);
    private static CloseableHttpClient closeableHttpClient;
    private static final Object LOCK;

    public static Response httpGet(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, Object> querys, List<String> signHeaderPrefixList, String appKey, String appSecret) throws Exception {
        headers = HttpUtil.initialBasicHeader("GET", path, headers, querys, null, signHeaderPrefixList, appKey, appSecret);
        CloseableHttpClient httpClient = HttpUtil.wrapClient(host);
        Object r = null;
        HttpGet get = new HttpGet(HttpUtil.initUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            get.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        CloseableHttpResponse rp = httpClient.execute((HttpUriRequest)get);
        return HttpUtil.convert(rp);
    }

    public static Response httpImgGet(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, Object> querys, List<String> signHeaderPrefixList, String appKey, String appSecret) throws Exception {
        headers = HttpUtil.initialBasicHeader("GET", path, headers, querys, null, signHeaderPrefixList, appKey, appSecret);
        CloseableHttpClient httpClient = HttpUtil.wrapClient(host);
        HttpGet get = new HttpGet(HttpUtil.initUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            get.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        CloseableHttpResponse rp = httpClient.execute((HttpUriRequest)get);
        return HttpUtil.convertDownload(rp);
    }

    public static Response httpPost(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, Object> querys, Map<String, String> bodys, List<String> signHeaderPrefixList, String appKey, String appSecret) throws Exception {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        headers = HttpUtil.initialBasicHeader("POST", path, headers, querys, bodys, signHeaderPrefixList, appKey, appSecret);
        CloseableHttpClient httpClient = HttpUtil.wrapClient(host);
        HttpPost post = new HttpPost(HttpUtil.initUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            post.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        UrlEncodedFormEntity formEntity = HttpUtil.buildFormEntity(bodys);
        if (formEntity != null) {
            post.setEntity((HttpEntity)formEntity);
        }
        return HttpUtil.convert(httpClient.execute((HttpUriRequest)post));
    }

    public static Response httpImgPost(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, Object> querys, Map<String, String> bodys, List<String> signHeaderPrefixList, String appKey, String appSecret) throws Exception {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        headers = HttpUtil.initialBasicHeader("POST", path, headers, querys, bodys, signHeaderPrefixList, appKey, appSecret);
        CloseableHttpClient httpClient = HttpUtil.wrapClient(host);
        HttpPost post = new HttpPost(HttpUtil.initUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            post.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        UrlEncodedFormEntity formEntity = HttpUtil.buildFormEntity(bodys);
        if (formEntity != null) {
            post.setEntity((HttpEntity)formEntity);
        }
        return HttpUtil.convert(httpClient.execute((HttpUriRequest)post));
    }

    public static Response httpPost(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, Object> querys, String body, List<String> signHeaderPrefixList, String appKey, String appSecret) throws Exception {
        String contentType = headers.get("Content-Type");
        if ("application/x-www-form-urlencoded;charset=UTF-8".equals(contentType)) {
            Map<String, String> paramMap = HttpUtil.strToMap(body);
            String modelDatas = paramMap.get("modelDatas");
            if (StringUtils.isNotBlank((CharSequence)modelDatas)) {
                paramMap.put("modelDatas", URLDecoder.decode(modelDatas));
            }
            headers = HttpUtil.initialBasicHeader("POST", path, headers, querys, paramMap, signHeaderPrefixList, appKey, appSecret);
        } else {
            headers = HttpUtil.initialBasicHeader("POST", path, headers, querys, null, signHeaderPrefixList, appKey, appSecret);
        }
        CloseableHttpClient httpClient = HttpUtil.wrapClient(host);
        HttpPost post = new HttpPost(HttpUtil.initUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            post.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            post.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        }
        return HttpUtil.convert(httpClient.execute((HttpUriRequest)post));
    }

    public static Response httpImgPost(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, Object> querys, String body, List<String> signHeaderPrefixList, String appKey, String appSecret) throws Exception {
        String contentType = headers.get("Content-Type");
        if ("application/x-www-form-urlencoded;charset=UTF-8".equals(contentType)) {
            Map<String, String> paramMap = HttpUtil.strToMap(body);
            String modelDatas = paramMap.get("modelDatas");
            if (StringUtils.isNotBlank((CharSequence)modelDatas)) {
                paramMap.put("modelDatas", URLDecoder.decode(modelDatas));
            }
            headers = HttpUtil.initialBasicHeader("POST", path, headers, querys, paramMap, signHeaderPrefixList, appKey, appSecret);
        } else {
            headers = HttpUtil.initialBasicHeader("POST", path, headers, querys, null, signHeaderPrefixList, appKey, appSecret);
        }
        CloseableHttpClient httpClient = HttpUtil.wrapClient(host);
        HttpPost post = new HttpPost(HttpUtil.initUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            post.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            post.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        }
        return HttpUtil.convert(httpClient.execute((HttpUriRequest)post));
    }

    public static Response httpPost(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, Object> querys, byte[] bodys, List<String> signHeaderPrefixList, String appKey, String appSecret) throws Exception {
        headers = HttpUtil.initialBasicHeader("POST", path, headers, querys, null, signHeaderPrefixList, appKey, appSecret);
        CloseableHttpClient httpClient = HttpUtil.wrapClient(host);
        HttpPost post = new HttpPost(HttpUtil.initUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            post.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        if (bodys != null) {
            post.setEntity((HttpEntity)new ByteArrayEntity(bodys));
        }
        return HttpUtil.convert(httpClient.execute((HttpUriRequest)post));
    }

    public static Response httpFilePost(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, Object> querys, Map<String, Object> bodys, List<String> signHeaderPrefixList, String appKey, String appSecret) throws Exception {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        HttpEntity formEntity = HttpUtil.buildFormHttpEntity(bodys);
        String boundary = null;
        if (formEntity != null) {
            String contentType = formEntity.getContentType().getValue();
            boundary = contentType.substring(contentType.indexOf(";") + 2, contentType.lastIndexOf(";")).trim();
        }
        headers.put("Content-Type", "multipart/form-data;charset=UTF-8;" + boundary);
        headers = HttpUtil.initialBasicHeader("POST", path, headers, querys, null, signHeaderPrefixList, appKey, appSecret);
        CloseableHttpClient httpClient = HttpUtil.wrapClient(host);
        HttpPost post = new HttpPost(HttpUtil.initUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            post.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        if (formEntity != null) {
            post.setEntity(formEntity);
        }
        return HttpUtil.convert(httpClient.execute((HttpUriRequest)post));
    }

    public static Response httpPut(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, Object> querys, String body, List<String> signHeaderPrefixList, String appKey, String appSecret) throws Exception {
        headers = HttpUtil.initialBasicHeader("PUT", path, headers, querys, null, signHeaderPrefixList, appKey, appSecret);
        CloseableHttpClient httpClient = HttpUtil.wrapClient(host);
        HttpPut put = new HttpPut(HttpUtil.initUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            put.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            put.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        }
        return HttpUtil.convert(httpClient.execute((HttpUriRequest)put));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response httpPut(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, Object> querys, byte[] bodys, List<String> signHeaderPrefixList, String appKey, String appSecret) throws Exception {
        headers = HttpUtil.initialBasicHeader("PUT", path, headers, querys, null, signHeaderPrefixList, appKey, appSecret);
        CloseableHttpClient httpClient = HttpUtil.wrapClient(host);
        HttpPut put = new HttpPut(HttpUtil.initUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            put.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        if (bodys != null) {
            put.setEntity((HttpEntity)new ByteArrayEntity(bodys));
        }
        Response r = null;
        try {
            r = HttpUtil.convert(httpClient.execute((HttpUriRequest)put));
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response httpDelete(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, Object> querys, List<String> signHeaderPrefixList, String appKey, String appSecret) throws Exception {
        headers = HttpUtil.initialBasicHeader("DELETE", path, headers, querys, null, signHeaderPrefixList, appKey, appSecret);
        CloseableHttpClient httpClient = HttpUtil.wrapClient(host);
        HttpDelete delete = new HttpDelete(HttpUtil.initUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            delete.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        Response r = null;
        try {
            r = HttpUtil.convert(httpClient.execute((HttpUriRequest)delete));
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return r;
    }

    public static Response httpPostDownload(String host, String path, int connectTimeout, Map<String, String> headers, Map<String, Object> querys, String body, List<String> signHeaderPrefixList, String appKey, String appSecret) throws Exception {
        String contentType = headers.get("Content-Type");
        if ("application/x-www-form-urlencoded;charset=UTF-8".equals(contentType)) {
            Map<String, String> paramMap = HttpUtil.strToMap(body);
            String modelDatas = paramMap.get("modelDatas");
            if (StringUtils.isNotBlank((CharSequence)modelDatas)) {
                paramMap.put("modelDatas", URLDecoder.decode(modelDatas));
            }
            headers = HttpUtil.initialBasicHeader("POST", path, headers, querys, paramMap, signHeaderPrefixList, appKey, appSecret);
        } else {
            headers = HttpUtil.initialBasicHeader("POST", path, headers, querys, null, signHeaderPrefixList, appKey, appSecret);
        }
        CloseableHttpClient httpClient = HttpUtil.wrapClient(host);
        HttpPost post = new HttpPost(HttpUtil.initUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            post.addHeader(e.getKey(), MessageDigestUtil.utf8ToIso88591(e.getValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            post.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        }
        return HttpUtil.convertDownload(httpClient.execute((HttpUriRequest)post));
    }

    private static UrlEncodedFormEntity buildFormEntity(Map<String, String> formParam) throws UnsupportedEncodingException {
        if (formParam != null) {
            ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
            for (String key : formParam.keySet()) {
                nameValuePairList.add(new BasicNameValuePair(key, formParam.get(key)));
            }
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(nameValuePairList, "UTF-8");
            formEntity.setContentType("application/x-www-form-urlencoded;charset=UTF-8");
            return formEntity;
        }
        return null;
    }

    public static String initUrl(String host, String path, Map<String, Object> querys) throws UnsupportedEncodingException {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(host);
        if (!StringUtils.isBlank((CharSequence)path)) {
            sbUrl.append(path);
        }
        if (null != querys) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry<String, Object> query : querys.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                if (StringUtils.isBlank((CharSequence)query.getKey()) && query.getValue() != null) {
                    sbQuery.append(query.getValue());
                }
                if (StringUtils.isBlank((CharSequence)query.getKey())) continue;
                sbQuery.append(query.getKey());
                if (query.getValue() == null) continue;
                sbQuery.append("=");
                sbQuery.append(URLEncoder.encode(query.getValue().toString(), "UTF-8"));
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append((CharSequence)sbQuery);
            }
        }
        return sbUrl.toString();
    }

    private static Map<String, String> initialBasicHeader(String method, String path, Map<String, String> headers, Map<String, Object> querys, Map<String, String> bodys, List<String> signHeaderPrefixList, String appKey, String appSecret) throws MalformedURLException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("x-ca-timestamp", String.valueOf(new Date().getTime()));
        headers.put("x-ca-nonce", UUID.randomUUID().toString());
        headers.put("x-ca-key", appKey);
        headers.put("x-ca-signature", SignUtil.sign(appSecret, method, path, headers, querys, bodys, signHeaderPrefixList));
        return headers;
    }

    private static int getTimeout(int timeout) {
        if (timeout == 0) {
            return Constants.DEFAULT_TIMEOUT;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response convert(CloseableHttpResponse response) throws IOException {
        try {
            Response res = new Response();
            if (null != response) {
                res.setStatusCode(response.getStatusLine().getStatusCode());
                for (Header header : response.getAllHeaders()) {
                    res.setHeader(header.getName(), MessageDigestUtil.iso88591ToUtf8(header.getValue()));
                }
                res.setContentType(res.getHeader("Content-Type"));
                res.setRequestId(res.getHeader("X-Ca-Request-Id"));
                res.setErrorMessage(res.getHeader("X-Ca-Error-Message"));
                if (response.getEntity() == null) {
                    res.setBody(null);
                } else {
                    res.setBody(HttpUtil.readStreamAsStr(response.getEntity().getContent()));
                }
            } else {
                res.setStatusCode(500);
                res.setErrorMessage("No Response");
            }
            Response response2 = res;
            return response2;
        }
        finally {
            if (null != response) {
                response.close();
            }
        }
    }

    private static Response convertDownload(CloseableHttpResponse response) throws IOException {
        Response res = new Response();
        if (null != response) {
            res.setStatusCode(response.getStatusLine().getStatusCode());
            for (Header header : response.getAllHeaders()) {
                res.setHeader(header.getName(), MessageDigestUtil.iso88591ToUtf8(header.getValue()));
            }
            res.setContentType(res.getHeader("Content-Type"));
            res.setRequestId(res.getHeader("X-Ca-Request-Id"));
            res.setErrorMessage(res.getHeader("X-Ca-Error-Message"));
            res.setResponse(response);
        } else {
            res.setStatusCode(500);
            res.setErrorMessage("No Response");
        }
        return res;
    }

    public static String readStreamAsStr(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        WritableByteChannel dest = Channels.newChannel(bos);
        ReadableByteChannel src = Channels.newChannel(is);
        ByteBuffer bb = ByteBuffer.allocate(4096);
        while (src.read(bb) != -1) {
            bb.flip();
            dest.write(bb);
            bb.clear();
        }
        src.close();
        dest.close();
        return new String(bos.toByteArray(), "UTF-8");
    }

    public static String readImageAsStr(byte[] src) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String inStream2String(InputStream src) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = -1;
        while ((len = src.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        return new String(baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient wrapClient(String host) {
        if (closeableHttpClient == null) {
            Object object = LOCK;
            synchronized (object) {
                if (closeableHttpClient == null) {
                    SSLContext sslContext = null;
                    if (host.startsWith("https://")) {
                        sslContext = HttpUtil.sslClientNewV2();
                    }
                    Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(sslContext != null ? sslContext : SSLContexts.createDefault(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
                    PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
                    connectionManager.setMaxTotal(300);
                    connectionManager.setDefaultMaxPerRoute(50);
                    connectionManager.closeExpiredConnections();
                    connectionManager.closeIdleConnections(30L, TimeUnit.SECONDS);
                    connectionManager.setValidateAfterInactivity(5000);
                    closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(HttpUtil.getConfig()).build();
                    return closeableHttpClient;
                }
            }
        }
        return closeableHttpClient;
    }

    @Deprecated
    private static SSLConnectionSocketFactory sslClientNew() {
        try {
            SSLContext ctx = null;
            String jdkVersion = System.getProperty("java.specification.version");
            ctx = Double.parseDouble(jdkVersion) >= (double)Constants.JDK_VERSION_11.intValue() ? SSLContext.getInstance("TLSv1.3") : (Double.parseDouble(jdkVersion) >= Constants.JDK_VERSION ? SSLContext.getInstance("TLSv1.2") : SSLContext.getInstance("TLS"));
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            return new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static SSLContext sslClientNewV2() {
        SSLContext sslContext;
        try {
            String jdkVersion = System.getProperty("java.specification.version");
            String protocol = Double.parseDouble(jdkVersion) >= (double)Constants.JDK_VERSION_11.intValue() ? "TLSv1.3" : (Double.parseDouble(jdkVersion) >= Constants.JDK_VERSION ? "TLSv1.2" : "TLS");
            sslContext = SSLContexts.custom().setProtocol(protocol).loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) {
                    return true;
                }
            }).build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        return sslContext;
    }

    private static Map<String, String> strToMap(String str) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String[] params;
            for (String param : params = str.split("&")) {
                String[] a = param.split("=");
                map.put(a[0], a[1]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private static HttpEntity buildFormHttpEntity(Map<String, Object> formParam) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
        String fileName = null;
        if (formParam != null) {
            try {
                for (Map.Entry<String, Object> entry : formParam.entrySet()) {
                    if (entry.getValue() instanceof String) {
                        builder.addTextBody(entry.getKey(), String.valueOf(entry.getValue()), ContentType.parse((String)"application/text;charset=UTF-8"));
                        continue;
                    }
                    if (entry.getValue() instanceof Number) {
                        builder.addTextBody(entry.getKey(), String.valueOf(entry.getValue()));
                        continue;
                    }
                    if (entry.getValue() instanceof Boolean) {
                        builder.addTextBody(entry.getKey(), String.valueOf(entry.getValue()));
                        continue;
                    }
                    if (entry.getValue() instanceof Enum) {
                        builder.addTextBody(entry.getKey(), String.valueOf(entry.getValue()));
                        continue;
                    }
                    if (entry.getValue() instanceof File) {
                        builder.addBinaryBody(entry.getKey(), (File)entry.getValue());
                        fileName = entry.getKey();
                        continue;
                    }
                    builder.addBinaryBody(entry.getKey(), (InputStream)entry.getValue());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (StringUtils.isNotBlank(fileName)) {
            formParam.remove(fileName);
        }
        builder.setContentType(ContentType.MULTIPART_FORM_DATA);
        return builder.build();
    }

    private static RequestConfig getConfig() {
        RequestConfig config = configMap.get("RequestConfig");
        if (config == null) {
            RequestConfig.Builder custom = RequestConfig.custom();
            custom.setConnectTimeout(Constants.DEFAULT_TIMEOUT);
            custom.setSocketTimeout(Constants.SOCKET_TIMEOUT);
            config = custom.build();
            configMap.put("RequestConfig", config);
        }
        return config;
    }

    static {
        LOCK = new Object();
    }
}

