/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.SysCamera;
import com.huimv.admin.entity.SysCameraArea;
import com.huimv.admin.entity.SysCameraBrand;
import com.huimv.admin.entity.vo.CameraListVo;
import com.huimv.admin.entity.vo.CameraListsVo;
import com.huimv.admin.entity.vo.CameraVo;
import com.huimv.admin.mapper.SysCameraAreaMapper;
import com.huimv.admin.mapper.SysCameraBrandMapper;
import com.huimv.admin.mapper.SysCameraMapper;
import com.huimv.admin.service.ISysCameraService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysCameraServiceImpl
extends ServiceImpl<SysCameraMapper, SysCamera>
implements ISysCameraService {
    @Autowired
    private SysCameraMapper cameraBaseMapper;
    @Autowired
    private SysCameraAreaMapper cameraAreaMapper;
    @Autowired
    private SysCameraBrandMapper cameraBrandMapper;

    public Result listPage(CameraListVo cameraListVo) {
        Integer current = cameraListVo.getCurrent();
        String strchStr = cameraListVo.getStrchStr();
        Integer size = cameraListVo.getSize();
        Integer areaId = cameraListVo.getAreaId();
        Integer brandId = cameraListVo.getBrandId();
        Integer sort = cameraListVo.getSort();
        Integer farmId = cameraListVo.getFarmId();
        Integer isOnline = cameraListVo.getIsOnline();
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)strchStr)) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.like((Object)"camera_name", (Object)strchStr)).or()).like((Object)"camera_ip", (Object)strchStr);
            });
        }
        if (farmId != null) {
            wrapper.eq((Object)"farm_id", (Object)farmId);
        }
        if (areaId != null) {
            wrapper.eq((Object)"area_id", (Object)areaId);
        }
        if (brandId != null) {
            wrapper.eq((Object)"brand_id", (Object)brandId);
        }
        if (isOnline != null) {
            wrapper.eq((Object)"is_online", (Object)isOnline);
        }
        if (sort == null) {
            wrapper.orderByDesc((Object)"id");
        } else if (sort == 1) {
            wrapper.orderByDesc((Object)"sort");
        } else {
            wrapper.orderByAsc((Object)"sort");
        }
        return new Result(ResultCode.SUCCESS, (Object)this.page((IPage)new Page((long)current.intValue(), (long)size.intValue()), (Wrapper)wrapper));
    }

    public List getCameraDetails(CameraListsVo cameraListsVo) throws InterruptedException {
        List cameraIds = cameraListsVo.getCameraIds();
        CameraListsVo cameraListVo = new CameraListsVo();
        cameraListVo.setCurrent(Integer.valueOf(1));
        cameraListVo.setSize(Integer.valueOf(10000));
        cameraListVo.setStrchStr(cameraListsVo.getStrchStr());
        cameraListVo.setAreaId(cameraListsVo.getAreaId());
        cameraListVo.setBrandId(cameraListsVo.getBrandId());
        cameraListVo.setSort(cameraListsVo.getSort());
        if (cameraIds == null || cameraIds.size() == 0) {
            return null;
        }
        ArrayList<CameraVo> cameraDetailsList = new ArrayList<CameraVo>();
        IPage page = (IPage)this.listPage((CameraListVo)cameraListVo).getData();
        List list = page.getRecords();
        int i = 0;
        String farmAppPort = "8081";
        String farmVideoApp = "/appleVideo/play?";
        String hlsMediaPort = "85";
        for (Integer cameraId : cameraIds) {
            for (SysCamera camera : list) {
                if (!cameraId.equals(camera.getId())) continue;
                String cameraAccount = camera.getAccount();
                String cameraPassword = camera.getPassword();
                String camerIp = camera.getCameraIp();
                String cameraName = camera.getCameraName();
                Integer areaId = camera.getAreaId();
                String url = ((SysCameraArea)this.cameraAreaMapper.selectById((Serializable)areaId)).getPublicUrl();
                SysCameraBrand cameraBrand = (SysCameraBrand)this.cameraBrandMapper.selectById((Serializable)camera.getBrandId());
                Integer type = cameraBrand.getStreamType();
                String rtsp = type == 0 ? cameraBrand.getMainStream() : cameraBrand.getAssistStream();
                CameraVo cameraVo = new CameraVo();
                cameraVo.setId(camera.getId());
                cameraVo.setAreaId(areaId);
                cameraVo.setWsUrl("ws://" + url + "/camera_relay?tcpaddr=" + cameraAccount + "%3A" + cameraPassword + "%40" + camerIp);
                cameraVo.setRtspUrl("rtsp://" + cameraAccount + ":" + cameraPassword + "@" + camerIp + rtsp);
                cameraVo.setCameraName(cameraName);
                cameraVo.setHttpUrl(this.handleHlsHttpUrl(url, cameraAccount, cameraPassword, camerIp, "8081", "/appleVideo/play?", "85"));
                if (i > 0) {
                    cameraVo.setLastId(((SysCamera)list.get(i - 1)).getId());
                }
                if (i < list.size() - 1) {
                    cameraVo.setNextId(((SysCamera)list.get(i + 1)).getId());
                }
                cameraDetailsList.add(cameraVo);
            }
            ++i;
        }
        return cameraDetailsList;
    }

    private String handleHlsHttpUrl(String url, String cameraAccount, String cameraPassword, String camerIp, String farmAppPort, String farmVideoApp, String hlsMediaPort) {
        url = url.substring(0, url.indexOf(":"));
        url = "http://" + url;
        return url + ":" + farmAppPort + farmVideoApp + "url=" + cameraAccount + ":" + cameraPassword + "@" + camerIp + "&dt=3000&targetUrl=" + url + ":" + hlsMediaPort;
    }

    public Result add(SysCamera camera) {
        Integer areaId = camera.getAreaId();
        Integer brandId = camera.getBrandId();
        int brandName = this.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"camera_name", (Object)camera.getCameraName())).eq((Object)"farm_id", (Object)camera.getFarmId()));
        if (brandName > 0) {
            return new Result(Integer.valueOf(10001), "\u6444\u50cf\u5934\u540d\u79f0\u91cd\u590d", false);
        }
        if (areaId != null) {
            camera.setAreaName(((SysCameraArea)this.cameraAreaMapper.selectById((Serializable)areaId)).getAreaName());
        }
        if (brandId != null) {
            camera.setBrandName(((SysCameraBrand)this.cameraBrandMapper.selectById((Serializable)brandId)).getBrandName());
        }
        this.save((Object)camera);
        return new Result(Integer.valueOf(10000), "\u6dfb\u52a0\u6210\u529f", true);
    }

    public Result updates(SysCamera camera) {
        Integer areaId = camera.getAreaId();
        Integer brandId = camera.getBrandId();
        this.updateById((Object)camera);
        int brandName = this.count((Wrapper)new QueryWrapper().eq((Object)"camera_name", (Object)camera.getCameraName()));
        if (brandName > 1) {
            return new Result(Integer.valueOf(10001), "\u6444\u50cf\u5934\u540d\u79f0\u91cd\u590d", false);
        }
        if (areaId != null) {
            camera.setAreaName(((SysCameraArea)this.cameraAreaMapper.selectById((Serializable)areaId)).getAreaName());
        }
        if (brandId != null) {
            camera.setBrandName(((SysCameraBrand)this.cameraBrandMapper.selectById((Serializable)brandId)).getBrandName());
        }
        this.updateById((Object)camera);
        return new Result(Integer.valueOf(10000), "\u4fee\u6539\u6210\u529f", true);
    }

    public CameraVo getCameraVo(SysCamera camera) {
        String cameraAccount = camera.getAccount();
        String cameraPassword = camera.getPassword();
        String camerIp = camera.getCameraIp();
        String cameraName = camera.getCameraName();
        Integer areaId = camera.getAreaId();
        String url = ((SysCameraArea)this.cameraAreaMapper.selectById((Serializable)areaId)).getPublicUrl();
        SysCameraBrand cameraBrand = (SysCameraBrand)this.cameraBrandMapper.selectById((Serializable)camera.getBrandId());
        Integer type = cameraBrand.getStreamType();
        String rtsp = type == 0 ? cameraBrand.getMainStream() : cameraBrand.getAssistStream();
        CameraVo cameraVo = new CameraVo();
        cameraVo.setAreaId(areaId);
        cameraVo.setWsUrl("ws://" + url + "/camera_relay?tcpaddr=" + cameraAccount + "%3A" + cameraPassword + "%40" + camerIp);
        cameraVo.setRtspUrl("rtsp://" + cameraAccount + ":" + cameraPassword + "@" + camerIp + rtsp);
        cameraVo.setCameraName(cameraName);
        return cameraVo;
    }
}

