/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.token.TokenSign;
import com.huimv.admin.common.utils.PhoneNumberValidator;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.common.utils.UploadImage;
import com.huimv.admin.entity.SysAccountMultilevel;
import com.huimv.admin.mapper.SysAccountMultilevelMapper;
import com.huimv.admin.service.ISysAccountMultilevelService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysAccountMultilevelServiceImpl
extends ServiceImpl<SysAccountMultilevelMapper, SysAccountMultilevel>
implements ISysAccountMultilevelService {
    @Autowired
    private SysAccountMultilevelMapper accountMultilevelMapper;
    @Autowired
    private UploadImage uploadImage;

    public Result findUserAccount(String searchStr, int pageNum, int pageSize, Integer userId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.like((Object)"pids", (Object)userId)).or()).eq((Object)"id", (Object)userId);
        IPage page = this.page((IPage)new Page((long)pageNum, (long)pageSize), (Wrapper)wrapper);
        return new Result(ResultCode.SUCCESS, (Object)page);
    }

    public Result add(SysAccountMultilevel sysAccountMultilevel, Integer userId) {
        int account = this.count((Wrapper)new QueryWrapper().eq((Object)"account", (Object)sysAccountMultilevel.getAccount()));
        if (account > 0) {
            return new Result(Integer.valueOf(10001), "\u8be5\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521b\u5efa", false);
        }
        SysAccountMultilevel byId = (SysAccountMultilevel)this.getById((Serializable)userId);
        sysAccountMultilevel.setPid(userId);
        sysAccountMultilevel.setPids(byId.getPids() + "," + userId);
        this.accountMultilevelMapper.insert((Object)sysAccountMultilevel);
        return new Result(Integer.valueOf(10000), "\u6dfb\u52a0\u6210\u529f", true);
    }

    public Result setAccountStatus(List<Integer> ids, Integer status) {
        try {
            for (Integer id : ids) {
                SysAccountMultilevel account = new SysAccountMultilevel();
                account.setId(id);
                account.setAccountStatus(status);
                this.updateById((Object)account);
            }
        }
        catch (Exception e) {
            return new Result(Integer.valueOf(10001), "\u63d2\u5165\u5931\u8d25", false);
        }
        String message = "";
        message = status == 1 ? "\u4f60\u9009\u62e9\u7684\u8d26\u53f7\u5df2\u7ecf\u542f\u7528\u3002" : "\u4f60\u9009\u62e9\u7684\u8d26\u53f7\u5df2\u7ecf\u6682\u505c\u542f\u7528\u3002";
        return new Result(Integer.valueOf(10000), message, true);
    }

    public List<Integer> getAllChildId(Integer userId) {
        List pids = this.list((Wrapper)new QueryWrapper().eq((Object)"pid", (Object)userId));
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (SysAccountMultilevel pid : pids) {
            list.add(pid.getId());
        }
        list.add(userId);
        return list;
    }

    public Result listSubordinate(String searchStr, int pageNum, int pageSize, Integer userId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.like((Object)"pids", (Object)userId);
        if (StringUtils.isNotBlank((CharSequence)searchStr)) {
            wrapper.like((Object)"user_name", (Object)searchStr);
        }
        IPage page = this.page((IPage)new Page((long)pageNum, (long)pageSize), (Wrapper)wrapper);
        return new Result(ResultCode.SUCCESS, (Object)page);
    }

    public Result getLastFarmId(Integer userId) {
        SysAccountMultilevel sysAccountMultilevel = (SysAccountMultilevel)this.accountMultilevelMapper.selectById((Serializable)userId);
        Integer lastFarmId = sysAccountMultilevel.getLastFarmId();
        String farmIds = sysAccountMultilevel.getFarmIds();
        if (farmIds == null) {
            return new Result(Integer.valueOf(10001), "\u8be5\u8d26\u53f7\u6ca1\u6709\u7ed1\u5b9a\u7267\u573a", true);
        }
        if (lastFarmId == null) {
            String[] split = farmIds.split(",");
            String s = split[0];
            sysAccountMultilevel.setLastFarmId(Integer.valueOf(s));
            this.accountMultilevelMapper.updateById((Object)sysAccountMultilevel);
            return new Result(ResultCode.SUCCESS, (Object)s);
        }
        return new Result(ResultCode.SUCCESS, (Object)lastFarmId);
    }

    public Result listSubordinateByFarm(String farmId, Integer userId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.like((Object)"pids", (Object)userId);
        wrapper.like((Object)"farm_ids", (Object)farmId);
        List page = this.list((Wrapper)wrapper);
        return new Result(ResultCode.SUCCESS, (Object)page);
    }

    @Transactional(rollbackFor={Exception.class})
    public Result updateUser(HttpServletRequest httpServletRequest, MultipartFile img, String userName, String phone) throws IOException {
        SysAccountMultilevel sysAccountMultilevel = (SysAccountMultilevel)this.accountMultilevelMapper.selectById((Serializable)TokenSign.getMemberIdByJwtToken((HttpServletRequest)httpServletRequest));
        if (ObjectUtil.isNotEmpty((Object)img)) {
            if (this.uploadImage.getImageCom(img).equals("\u4e0a\u4f20\u5931\u8d25")) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return new Result(Integer.valueOf(10001), "\u56fe\u7247\u4e0a\u4f20\u5931\u8d25", false);
            }
            sysAccountMultilevel.setImgUrl(this.uploadImage.getImageCom(img));
        }
        if (ObjectUtil.isNotEmpty((Object)userName)) {
            sysAccountMultilevel.setUserName(userName);
        }
        if (ObjectUtil.isNotEmpty((Object)phone)) {
            if (!PhoneNumberValidator.isValidPhoneNumber((String)phone)) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return new Result(Integer.valueOf(10001), "\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff01", false);
            }
            sysAccountMultilevel.setPhone(phone);
        }
        this.accountMultilevelMapper.updateById((Object)sysAccountMultilevel);
        return new Result(ResultCode.SUCCESS, (Object)sysAccountMultilevel);
    }
}

