/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.DataUill;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.BaseBuilding;
import com.huimv.admin.entity.ProtEnvData;
import com.huimv.admin.entity.vo.ProtDataVo;
import com.huimv.admin.entity.vo.ProtDataVo2;
import com.huimv.admin.mapper.BaseBuildingMapper;
import com.huimv.admin.mapper.ProtEnvDataMapper;
import com.huimv.admin.service.IProtEnvDataService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProtEnvDataServiceImpl
extends ServiceImpl<ProtEnvDataMapper, ProtEnvData>
implements IProtEnvDataService {
    @Autowired
    private ProtEnvDataMapper envDataMapper;
    @Autowired
    private BaseBuildingMapper buildingMapper;

    public Result listData(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String unitId = paramsMap.get("unitId");
        String startDate = paramsMap.get("startDate");
        String endDate = paramsMap.get("endDate");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).eq((Object)"unit_id", (Object)unitId)).between(StringUtils.isNotBlank((CharSequence)startDate), (Object)"create_time", (Object)startDate, (Object)endDate);
        return new Result(ResultCode.SUCCESS, (Object)this.envDataMapper.selectList((Wrapper)queryWrapper));
    }

    public Result listHistory(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String unitId = paramsMap.get("unitId");
        String timeType = paramsMap.get("timeType");
        if ("".equals(timeType) || null == timeType) {
            timeType = "1";
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).eq((Object)"unit_id", (Object)unitId);
        List protEnvData = null;
        if ("1".equals(timeType)) {
            Date timesmorning = DataUill.getTimesmorning();
            queryWrapper.ge((Object)"create_time", (Object)timesmorning);
            protEnvData = this.envDataMapper.listDataDay(queryWrapper);
        } else if ("2".equals(timeType)) {
            DateTime dateTime = DateUtil.beginOfWeek((Date)new Date());
            queryWrapper.ge((Object)"create_time", (Object)dateTime);
            protEnvData = this.envDataMapper.listData(queryWrapper);
        } else if ("3".equals(timeType)) {
            Date monthmorning = DataUill.getTimesMonthmorning();
            queryWrapper.ge((Object)"create_time", (Object)monthmorning);
            protEnvData = this.envDataMapper.listData(queryWrapper);
        } else if ("4".equals(timeType)) {
            String startDate = paramsMap.get("startDate");
            String endDate = paramsMap.get("endDate");
            queryWrapper.between((Object)"create_time", (Object)startDate, (Object)endDate);
            protEnvData = this.envDataMapper.listData(queryWrapper);
        }
        return new Result(ResultCode.SUCCESS, (Object)protEnvData);
    }

    public Result listScreen(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        QueryWrapper buildingQueryWrapper = new QueryWrapper();
        ((QueryWrapper)buildingQueryWrapper.eq((Object)"farm_id", (Object)farmId)).eq((Object)"f_type", (Object)1);
        List buildings = this.buildingMapper.selectList((Wrapper)buildingQueryWrapper);
        JSONArray jsonArray = new JSONArray();
        if (buildings.size() != 0) {
            for (BaseBuilding building : buildings) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("unitName", (Object)building.getBuildName());
                jsonObject.put("unitId", (Object)building.getId());
                QueryWrapper queryWrapper = new QueryWrapper();
                ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).orderByDesc((Object)"id")).last(" limit 1")).eq((Object)"unit_id", (Object)building.getId());
                ProtEnvData protEnvData = (ProtEnvData)this.envDataMapper.selectOne((Wrapper)queryWrapper);
                if (ObjectUtil.isNotEmpty((Object)protEnvData)) {
                    jsonObject.put("hum", (Object)protEnvData.getHum());
                    jsonObject.put("temp", (Object)protEnvData.getTemp());
                    jsonObject.put("nh3n", (Object)protEnvData.getNh3n());
                    jsonObject.put("h2s", (Object)protEnvData.getH2s());
                    jsonObject.put("lighting", (Object)protEnvData.getLighting());
                } else {
                    jsonObject.put("hum", (Object)"--");
                    jsonObject.put("temp", (Object)"--");
                    jsonObject.put("nh3n", (Object)"--");
                    jsonObject.put("h2s", (Object)"--");
                    jsonObject.put("lighting", (Object)"--");
                }
                jsonArray.add((Object)jsonObject);
            }
        }
        return new Result(ResultCode.SUCCESS, (Object)jsonArray);
    }

    public Result listByType(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        Date timesmorning = DataUill.getTimesmorning();
        ArrayList<ProtDataVo2> list = new ArrayList<ProtDataVo2>();
        QueryWrapper queryWrapper1 = new QueryWrapper();
        ((QueryWrapper)queryWrapper1.eq((Object)"farm_id", (Object)farmId)).eq((Object)"f_type", (Object)1);
        List buildings = this.buildingMapper.selectList((Wrapper)queryWrapper1);
        if (buildings.size() != 0) {
            for (BaseBuilding building : buildings) {
                ProtDataVo2 protDataVo2 = new ProtDataVo2();
                protDataVo2.setUnitId(building.getId());
                protDataVo2.setUnitName(building.getBuildName());
                QueryWrapper queryWrapper = new QueryWrapper();
                ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).eq((Object)"unit_id", (Object)building.getId())).ge((Object)"create_time", (Object)timesmorning);
                List protDataVos = this.envDataMapper.listScreen(queryWrapper);
                protDataVo2.setList(protDataVos);
                if (protDataVos.size() != 0) {
                    ProtDataVo protDataVo = (ProtDataVo)protDataVos.get(protDataVos.size() - 1);
                    protDataVo2.setH2s(protDataVo.getHum());
                    protDataVo2.setNh3n(protDataVo.getNh3n());
                    protDataVo2.setTemp(protDataVo.getTemp());
                    protDataVo2.setHum(protDataVo.getHum());
                } else {
                    protDataVo2.setH2s("0");
                    protDataVo2.setNh3n("0");
                    protDataVo2.setTemp("0");
                    protDataVo2.setHum("0");
                }
                list.add(protDataVo2);
            }
        }
        return new Result(ResultCode.SUCCESS, list);
    }
}

