/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.DataUill;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.ProtDisease;
import com.huimv.admin.mapper.ProtDiseaseMapper;
import com.huimv.admin.service.IProtDiseaseService;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProtDiseaseServiceImpl
extends ServiceImpl<ProtDiseaseMapper, ProtDisease>
implements IProtDiseaseService {
    @Autowired
    private ProtDiseaseMapper diseaseMapper;

    public Result listPage(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String startDate = paramsMap.get("startDate");
        String endDate = paramsMap.get("endDate");
        String type = paramsMap.get("type");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        String sheepId = paramsMap.get("sheepId");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).like(StringUtils.isNotBlank((CharSequence)sheepId), (Object)"sheep_id", (Object)sheepId)).between(StringUtils.isNotBlank((CharSequence)startDate), (Object)"create_time", (Object)(startDate + " 00:00:00"), (Object)(endDate + " 23:59:59"));
        if (!"0".equals(type)) {
            queryWrapper.eq((Object)"status", (Object)type);
        }
        return new Result(ResultCode.SUCCESS, (Object)this.diseaseMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    public Result diseaseAnalysis(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String timeType = paramsMap.get("timeType");
        if ("".equals(timeType) || null == timeType) {
            timeType = "2";
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"farm_id", (Object)farmId);
        if ("1".equals(timeType)) {
            Date timesmorning = DataUill.getTimesmorning();
            queryWrapper.ge((Object)"create_time", (Object)timesmorning);
        } else if ("2".equals(timeType)) {
            DateTime dateTime = DateUtil.beginOfWeek((Date)new Date());
            queryWrapper.ge((Object)"create_time", (Object)dateTime);
        } else if ("3".equals(timeType)) {
            DateTime dateTime = DateUtil.beginOfMonth((Date)new Date());
            queryWrapper.ge((Object)"create_time", (Object)dateTime);
        } else if ("4".equals(timeType)) {
            String startTime = paramsMap.get("startTime");
            String endTime = paramsMap.get("endTime");
            queryWrapper.between((Object)"create_time", (Object)startTime, (Object)endTime);
        }
        return new Result(ResultCode.SUCCESS, (Object)this.diseaseMapper.diseaseAnalysis(queryWrapper));
    }
}

