/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.ProtBatch;
import com.huimv.admin.entity.ProtSheepInfo;
import com.huimv.admin.entity.vo.ProtBatchAddVo;
import com.huimv.admin.mapper.ProtBatchMapper;
import com.huimv.admin.mapper.ProtSheepInfoMapper;
import com.huimv.admin.service.IProtBatchService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProtBatchServiceImpl
extends ServiceImpl<ProtBatchMapper, ProtBatch>
implements IProtBatchService {
    @Autowired
    private ProtBatchMapper batchMapper;
    @Autowired
    private ProtSheepInfoMapper sheepInfoMapper;

    public Result listPage(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        String batchNum = paramsMap.get("batchNum");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).like(StringUtils.isNotBlank((CharSequence)batchNum), (Object)"batch_num", (Object)batchNum);
        return new Result(ResultCode.SUCCESS, (Object)this.batchMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    @Transactional
    public Result addBatch(ProtBatchAddVo batchAddVo) {
        Integer dayCount = 0;
        BigDecimal weight = BigDecimal.ZERO;
        Integer number = batchAddVo.getSheepInfos().size();
        ProtBatch protBatch = new ProtBatch();
        protBatch.setRemark(batchAddVo.getRemark());
        protBatch.setBatchNum(batchAddVo.getBatchNum());
        protBatch.setNumber(number);
        protBatch.setFarmId(batchAddVo.getFarmId());
        protBatch.setRegisterUser(batchAddVo.getRegisterUser());
        protBatch.setCreateTime(batchAddVo.getCreateTime());
        List sheepInfos = batchAddVo.getSheepInfos();
        for (ProtSheepInfo sheepInfo : sheepInfos) {
            sheepInfo.setIsBatch(Integer.valueOf(1));
            dayCount = dayCount + sheepInfo.getSheepDay();
            BigDecimal db = new BigDecimal(sheepInfo.getSheepWeight());
            weight = weight.add(db);
            sheepInfo.setBatchNum(batchAddVo.getBatchNum());
            this.sheepInfoMapper.updateById((Object)sheepInfo);
        }
        BigDecimal num2 = new BigDecimal(number);
        BigDecimal avgWeight = weight.divide(num2);
        protBatch.setAvgWeight(Double.valueOf(avgWeight.doubleValue()));
        protBatch.setAvgDay(Integer.valueOf(dayCount / number));
        this.batchMapper.insert((Object)protBatch);
        return new Result(ResultCode.SUCCESS);
    }
}

