/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.AccountGroup;
import com.huimv.admin.entity.Group;
import com.huimv.admin.mapper.AccountGroupMapper;
import com.huimv.admin.mapper.GroupMapper;
import com.huimv.admin.mapper.GroupMenuMapper;
import com.huimv.admin.service.IGroupService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class GroupServiceImpl
extends ServiceImpl<GroupMapper, Group>
implements IGroupService {
    @Autowired
    private GroupMapper groupMapper;
    @Autowired
    private GroupMenuMapper groupMenuMapper;
    @Autowired
    private AccountGroupMapper accountGroupMapper;

    public Result updateGroup(@RequestBody Group group) {
        try {
            this.groupMapper.updateById((Object)group);
            return new Result(Integer.valueOf(10000), "\u4fee\u6539\u6210\u529f", true);
        }
        catch (Exception e) {
            return new Result(Integer.valueOf(10001), "\u4fee\u6539\u5931\u8d25", false);
        }
    }

    @Transactional
    public Result removeGroup(Integer groupId) {
        try {
            Group group = (Group)this.groupMapper.selectById((Serializable)groupId);
            if (group == null) {
                return new Result(Integer.valueOf(10002), "\u8bf7\u9009\u62e9\u6570\u636e", false);
            }
            this.groupMapper.deleteById((Serializable)groupId);
            QueryWrapper groupMenuQueryWrapper = new QueryWrapper();
            groupMenuQueryWrapper.eq((Object)"group_id", (Object)groupId);
            this.groupMenuMapper.delete((Wrapper)groupMenuQueryWrapper);
            return new Result(Integer.valueOf(10000), "\u5220\u9664\u6210\u529f", true);
        }
        catch (Exception e) {
            return new Result(Integer.valueOf(10001), "\u5220\u9664\u5931\u8d25", false);
        }
    }

    public Result listGroup(Map map, List<Integer> allChildId) {
        Integer pageNum = (Integer)map.get("pageNum");
        Integer pageSize = (Integer)map.get("pageSize");
        Page page = (Page)this.page((IPage)new Page((long)pageNum.intValue(), (long)pageSize.intValue()), (Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"account_id", allChildId)).orderByDesc((Object)"id"));
        return new Result(ResultCode.SUCCESS, (Object)page);
    }

    public Result addGroup(Group group, Integer userId) {
        try {
            group.setAccountId(userId);
            this.groupMapper.insert((Object)group);
            return new Result(Integer.valueOf(10000), "\u6dfb\u52a0\u6210\u529f", true);
        }
        catch (Exception e) {
            return new Result(Integer.valueOf(10001), "\u6dfb\u52a0\u5931\u8d25", false);
        }
    }

    public Result getGroupByUserId(Integer userId) {
        List accountId = this.accountGroupMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"account_id", (Object)userId));
        List collect = accountId.stream().map(AccountGroup::getGroupId).collect(Collectors.toList());
        return new Result(ResultCode.SUCCESS, collect);
    }
}

