/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.EarmarkThreshold;
import com.huimv.admin.mapper.EarmarkThresholdMapper;
import com.huimv.admin.service.IEarmarkThresholdService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EarmarkThresholdServiceImpl
extends ServiceImpl<EarmarkThresholdMapper, EarmarkThreshold>
implements IEarmarkThresholdService {
    @Autowired
    private EarmarkThresholdMapper thresholdMapper;

    public Result listThreshold(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        EarmarkThreshold threshold = (EarmarkThreshold)this.thresholdMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"farm_id", (Object)farmId));
        return new Result(ResultCode.SUCCESS, (Object)threshold);
    }

    public Result addAndEdit(EarmarkThreshold threshold) {
        Integer farmId = threshold.getFarmId();
        Integer count = this.thresholdMapper.selectCount((Wrapper)new QueryWrapper().eq((Object)"farm_id", (Object)farmId));
        if (count == 0) {
            this.thresholdMapper.insert((Object)threshold);
        } else {
            this.thresholdMapper.updateById((Object)threshold);
        }
        JSONObject paramMap = new JSONObject();
        paramMap.put("farmId", (Object)farmId);
        paramMap.put("deviceOfflineTime", (Object)(threshold.getCollectorHour() * 60));
        paramMap.put("eartagMaxTem", (Object)threshold.getActUpper());
        paramMap.put("eartagMinTem", (Object)threshold.getTempDown());
        paramMap.put("eartagOfflineTime", (Object)(threshold.getEarmarkHour() * 60));
        String result = ((HttpRequest)HttpRequest.post((String)"https://eartag.alafarms.com/api/manage2/config/updateWarning").header(Header.CONTENT_TYPE, "application/json")).body(paramMap.toJSONString()).timeout(30000).execute().body();
        return new Result(ResultCode.SUCCESS, (Object)result);
    }
}

