/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.BreedLeave;
import com.huimv.admin.entity.ProtSheepInfo;
import com.huimv.admin.entity.SheepEarmark;
import com.huimv.admin.mapper.BreedLeaveMapper;
import com.huimv.admin.mapper.ProtSheepInfoMapper;
import com.huimv.admin.mapper.SheepEarmarkMapper;
import com.huimv.admin.service.IBreedLeaveService;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BreedLeaveServiceImpl
extends ServiceImpl<BreedLeaveMapper, BreedLeave>
implements IBreedLeaveService {
    @Autowired
    private BreedLeaveMapper leaveMapper;
    @Autowired
    private SheepEarmarkMapper earmarkMapper;
    @Autowired
    private ProtSheepInfoMapper sheepInfoMapper;

    public Result listPage(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        String sheepId = paramsMap.get("sheepId");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).like(StringUtils.isNotBlank((CharSequence)sheepId), (Object)"sheep_id", (Object)sheepId);
        return new Result(ResultCode.SUCCESS, (Object)this.leaveMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    public Result add(BreedLeave breedLeave) {
        String sheepId = breedLeave.getSheepId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"earmark", (Object)sheepId);
        SheepEarmark earmark = (SheepEarmark)this.earmarkMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)earmark)) {
            earmark.setIsUse(Integer.valueOf(0));
            this.earmarkMapper.updateById((Object)earmark);
        }
        Date time = breedLeave.getCreateTime();
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"sheep_id", (Object)sheepId);
        ProtSheepInfo sheepInfo = (ProtSheepInfo)this.sheepInfoMapper.selectOne((Wrapper)queryWrapper1);
        sheepInfo.setIsLeave(Integer.valueOf(1));
        this.sheepInfoMapper.updateById((Object)sheepInfo);
        Date birthTime = sheepInfo.getBirthTime();
        long l = time.getTime() - birthTime.getTime();
        long l1 = l / 86400000L;
        breedLeave.setDayage(Integer.valueOf((int)l1));
        return new Result(ResultCode.SUCCESS, (Object)this.leaveMapper.insert((Object)breedLeave));
    }

    public Result edit(BreedLeave breedLeave) {
        if (breedLeave.getIsWithdraw() == 1) {
            String sheepId = breedLeave.getSheepId();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"earmark", (Object)sheepId);
            SheepEarmark earmark = (SheepEarmark)this.earmarkMapper.selectOne((Wrapper)queryWrapper);
            if (ObjectUtil.isNotEmpty((Object)earmark)) {
                earmark.setIsUse(Integer.valueOf(1));
                this.earmarkMapper.updateById((Object)earmark);
            }
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.eq((Object)"sheep_id", (Object)sheepId);
            ProtSheepInfo sheepInfo = (ProtSheepInfo)this.sheepInfoMapper.selectOne((Wrapper)queryWrapper1);
            sheepInfo.setIsLeave(Integer.valueOf(0));
            this.sheepInfoMapper.updateById((Object)sheepInfo);
            this.leaveMapper.deleteById((Serializable)breedLeave);
            return new Result(ResultCode.SUCCESS);
        }
        return new Result(ResultCode.SUCCESS, (Object)this.leaveMapper.updateById((Object)breedLeave));
    }

    public Result remove(Map<String, String> paramsMap) {
        String[] split;
        String ids = paramsMap.get("ids");
        for (String s : split = ids.split(",")) {
            this.leaveMapper.deleteById((Serializable)((Object)s));
        }
        return new Result(ResultCode.SUCCESS);
    }
}

