/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.common.utils.ResultUtil;
import com.huimv.admin.entity.BaseBuilding;
import com.huimv.admin.entity.ProtEnvDevice;
import com.huimv.admin.entity.ProtSheepInfo;
import com.huimv.admin.mapper.BaseBuildingMapper;
import com.huimv.admin.mapper.ProtEnvDeviceMapper;
import com.huimv.admin.mapper.ProtSheepInfoMapper;
import com.huimv.admin.service.IBaseBuildingService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseBuildingServiceImpl
extends ServiceImpl<BaseBuildingMapper, BaseBuilding>
implements IBaseBuildingService {
    @Autowired
    private BaseBuildingMapper baseBuildingMapper;
    @Autowired
    private ProtSheepInfoMapper sheepInfoMapper;
    @Autowired
    private ProtEnvDeviceMapper deviceMapper;

    @Transactional
    public Result addBuilding(BaseBuilding baseBuilding) {
        if (this.count((Wrapper)new QueryWrapper().eq((Object)"build_name", (Object)baseBuilding.getBuildName())) != 0) {
            return new Result(Integer.valueOf(10001), "\u680b\u820d\u540d\u5df2\u5b58\u5728", false);
        }
        baseBuilding.setParentId(Integer.valueOf(0));
        baseBuilding.setFType(Integer.valueOf(1));
        this.save((Object)baseBuilding);
        return Result.SUCCESS();
    }

    @Transactional
    public Result updateBuilding(BaseBuilding baseBuilding) {
        if (this.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"build_name", (Object)baseBuilding.getBuildName())).ne((Object)"id", (Object)baseBuilding.getId())) != 0) {
            return new Result(Integer.valueOf(10001), "\u680b\u820d\u540d\u5df2\u5b58\u5728", false);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"unit_id", (Object)baseBuilding.getId())).eq((Object)"farm_id", (Object)baseBuilding.getFarmId())).eq((Object)"is_leave", (Object)0);
        List protSheepInfos = this.sheepInfoMapper.selectList((Wrapper)queryWrapper);
        for (ProtSheepInfo protSheepInfo : protSheepInfos) {
            protSheepInfo.setUnitId(baseBuilding.getId());
            protSheepInfo.setUnitName(baseBuilding.getBuildName());
            this.sheepInfoMapper.updateById((Object)protSheepInfo);
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        ((QueryWrapper)queryWrapper1.eq((Object)"farm_id", (Object)baseBuilding.getFarmId())).eq((Object)"unit_id", (Object)baseBuilding.getId());
        List envDevices = this.deviceMapper.selectList((Wrapper)queryWrapper1);
        for (ProtEnvDevice envDevice : envDevices) {
            envDevice.setUnitName(baseBuilding.getBuildName());
            this.deviceMapper.updateById((Object)envDevice);
        }
        this.baseBuildingMapper.updateById((Object)baseBuilding);
        return ResultUtil.updateResult((Integer)1);
    }

    @Transactional
    public Result deleteBuilding(Map<String, Integer> map) {
        Integer id = map.get("id");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"unit_id", (Object)id)).eq((Object)"is_leave", (Object)0);
        if (this.sheepInfoMapper.selectCount((Wrapper)queryWrapper) != 0) {
            return new Result(Integer.valueOf(10001), "\u5220\u9664\u5931\u8d25\uff0c\u8be5\u680b\u820d\u4e0b\u5c5e\u7b3c\u4e2d\u5b58\u5728\u7f8a\u53ea", false);
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"unit_id", (Object)id);
        if (this.deviceMapper.selectCount((Wrapper)queryWrapper1) != 0) {
            return new Result(Integer.valueOf(10001), "\u5220\u9664\u5931\u8d25\uff0c\u8be5\u680b\u820d\u5b58\u5728\u8bbe\u5907", false);
        }
        this.removeById((Serializable)id);
        return new Result(Integer.valueOf(10000), "\u5220\u9664\u6210\u529f", true);
    }

    public Result listBuilding(Map<String, String> map) {
        String farmId = map.get("farmId");
        String buildType = map.get("buildType");
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"farm_id", (Object)farmId)).eq((Object)"f_type", (Object)1)).eq(StringUtils.isNotBlank((CharSequence)buildType), (Object)"build_type", (Object)buildType);
        return new Result(ResultCode.SUCCESS, (Object)this.baseBuildingMapper.selectList((Wrapper)queryWrapper));
    }

    public Result listTreeBuilding(Map<String, String> map) {
        String farmId = map.get("farmId");
        List baseBuildings = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"farm_id", (Object)farmId)).orderByAsc((Object)"id"));
        return new Result(ResultCode.SUCCESS, (Object)baseBuildings);
    }
}

