/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.huimv.admin.common.utils.ConstUtil;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.AccountGroup;
import com.huimv.admin.entity.Farm;
import com.huimv.admin.entity.GroupMenu;
import com.huimv.admin.entity.Menu;
import com.huimv.admin.mapper.AccountGroupMapper;
import com.huimv.admin.mapper.FarmMapper;
import com.huimv.admin.mapper.GroupMenuMapper;
import com.huimv.admin.mapper.MenuMapper;
import com.huimv.admin.service.IAuthorizeService;
import com.huimv.admin.service.IGroupMenuService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthorizeServiceImpl
implements IAuthorizeService {
    @Autowired
    AccountGroupMapper accountGroupMapper;
    @Autowired
    GroupMenuMapper groupMenuMapper;
    @Autowired
    IGroupMenuService groupMenuService;
    @Autowired
    private MenuMapper menuMapper;
    @Autowired
    private FarmMapper farmMapper;

    @Transactional
    public Result saveAccountGroup(String accountId, String groupIds) {
        if (accountId == null || "".equals(accountId)) {
            this.accountGroupMapper.removeAccountGroup(groupIds);
            return new Result(Integer.valueOf(10000), "\u4fdd\u5b58\u8d26\u53f7\u5173\u8054\u6743\u9650\u7ec4\u6210\u529f", true);
        }
        String[] groupIdArray = accountId.split(",");
        this.accountGroupMapper.removeAccountGroup(accountId);
        for (int a = 0; a < groupIdArray.length; ++a) {
            AccountGroup accountGroupEntity = new AccountGroup();
            accountGroupEntity.setAccountId(Integer.valueOf(Integer.parseInt(groupIdArray[a])));
            accountGroupEntity.setGroupId(Integer.valueOf(Integer.parseInt(groupIds)));
            this.accountGroupMapper.insert((Object)accountGroupEntity);
        }
        return new Result(Integer.valueOf(10000), "\u4fdd\u5b58\u8d26\u53f7\u5173\u8054\u6743\u9650\u7ec4\u6210\u529f", true);
    }

    @Transactional
    public Result saveGroupMenu(String groupId, String menuIds, String isAll) {
        this.groupMenuMapper.removeGroupMenu(groupId);
        if (StringUtils.isNotBlank((CharSequence)menuIds)) {
            String[] menuIdsArray = menuIds.split(",");
            String[] split = isAll.split(",");
            ArrayList<GroupMenu> list = new ArrayList<GroupMenu>();
            for (int a = 0; a < menuIdsArray.length; ++a) {
                GroupMenu groupMenu = new GroupMenu();
                groupMenu.setGroupId(Integer.valueOf(Integer.parseInt(groupId)));
                groupMenu.setMenuId(Integer.valueOf(Integer.parseInt(menuIdsArray[a])));
                list.add(groupMenu);
            }
            if (StringUtils.isNotBlank((CharSequence)isAll)) {
                for (GroupMenu groupMenu : list) {
                    for (String s : split) {
                        if (groupMenu.getMenuId() != Integer.parseInt(s)) continue;
                        groupMenu.setIsAll(Integer.valueOf(1));
                    }
                }
            }
            this.groupMenuService.saveBatch(list);
        }
        return new Result(Integer.valueOf(10000), "\u4fdd\u5b58\u6743\u9650\u7ec4\u5173\u8054\u83dc\u5355\u6210\u529f", true);
    }

    public Result getMenuByGroup(Map paramsMap) {
        String groupId = (String)paramsMap.get("groupId");
        QueryWrapper groupMenuQueryWrapper = new QueryWrapper();
        groupMenuQueryWrapper.eq((Object)"group_id", (Object)groupId);
        groupMenuQueryWrapper.eq((Object)"is_all", (Object)0);
        List groupMenuEntityList = this.groupMenuMapper.selectList((Wrapper)groupMenuQueryWrapper);
        if (groupMenuEntityList.size() == 0) {
            return new Result(Integer.valueOf(10005), "\u5f53\u524d\u6743\u9650\u7ec4\u6682\u672a\u5173\u8054\u4efb\u4f55\u83dc\u5355.", false);
        }
        StringBuilder stringBuffer = new StringBuilder();
        for (GroupMenu groupMenu : groupMenuEntityList) {
            stringBuffer.append(groupMenu.getMenuId());
            stringBuffer.append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return new Result(ResultCode.SUCCESS, (Object)stringBuffer.toString());
    }

    public Result getMenuByGroupAndFarm(Map<String, String> map) {
        String groupId = map.get("groupId");
        String farmId = map.get("farmId");
        Farm farm = (Farm)this.farmMapper.selectById((Serializable)((Object)farmId));
        String farmMenu = farm.getFarmMenu();
        if (StringUtils.isNotBlank((CharSequence)farmMenu)) {
            return new Result(ConstUtil.ERR_MYMENU_EMPTY_CODE, "\u8be5\u7267\u573a\u65e0\u4efb\u4f55\u6388\u6743\u83dc\u5355", false);
        }
        List<String> list = Arrays.asList(farmMenu);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)groupId), (Object)"group_id", (Object)groupId);
        queryWrapper.in((Object)"menu_id", list);
        List groupMenuEntityList = this.groupMenuMapper.selectList((Wrapper)queryWrapper);
        if (groupMenuEntityList.size() == 0) {
            return new Result(Integer.valueOf(10005), "\u5f53\u524d\u6743\u9650\u7ec4\u6682\u672a\u5173\u8054\u4efb\u4f55\u83dc\u5355.", false);
        }
        StringBuilder stringBuffer = new StringBuilder();
        for (GroupMenu groupMenu : groupMenuEntityList) {
            stringBuffer.append(groupMenu.getMenuId());
            stringBuffer.append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return new Result(ResultCode.SUCCESS, (Object)stringBuffer.toString());
    }

    public Result getGroupByAccount(String accountId) {
        QueryWrapper accountGroupQueryWrapper = new QueryWrapper();
        accountGroupQueryWrapper.eq((Object)"account_id", (Object)accountId);
        List accountGroupEntityList = this.accountGroupMapper.selectList((Wrapper)accountGroupQueryWrapper);
        if (accountGroupEntityList.size() == 0) {
            return new Result(Integer.valueOf(10006), "\u5f53\u524d\u7528\u6237\u8d26\u53f7\u6682\u672a\u5173\u8054\u4efb\u4f55\u6743\u9650\u7ec4.", false);
        }
        StringBuilder idSb = new StringBuilder();
        for (AccountGroup accountGroupEntity : accountGroupEntityList) {
            if (idSb.length() > 0) {
                idSb.append(",");
            }
            idSb.append(accountGroupEntity.getGroupId());
        }
        return new Result(ResultCode.SUCCESS, (Object)idSb.toString());
    }

    public Result getAccountByGroup(String groupId) {
        QueryWrapper accountGroupQueryWrapper = new QueryWrapper();
        accountGroupQueryWrapper.eq((Object)"group_id", (Object)groupId);
        List accountGroupEntityList = this.accountGroupMapper.selectList((Wrapper)accountGroupQueryWrapper);
        if (accountGroupEntityList.size() == 0) {
            return new Result(Integer.valueOf(10006), "\u5f53\u524d\u6743\u9650\u7ec4\u6682\u672a\u5173\u8054\u4efb\u4f55\u7528\u6237\u8d26\u53f7.", false);
        }
        StringBuilder idSb = new StringBuilder();
        for (AccountGroup accountGroupEntity : accountGroupEntityList) {
            if (idSb.length() > 0) {
                idSb.append(",");
            }
            idSb.append(accountGroupEntity.getAccountId());
        }
        return new Result(ResultCode.SUCCESS, (Object)idSb.toString());
    }

    public List getMyMenuAll(String accountName, String farmId) {
        if ("1".equals(accountName)) {
            List menus = this.menuMapper.selectList((Wrapper)new QueryWrapper().orderByAsc((Object)"sort"));
            return menus;
        }
        Farm farm = (Farm)this.farmMapper.selectById((Serializable)((Object)farmId));
        String farmMenu = farm.getFarmMenu();
        String[] farmMenus = farmMenu.split(",");
        return this.menuMapper.getMyMenu(accountName, farmMenus);
    }

    public List<String> getMyButton(Integer userId, Integer farmId) {
        Farm farm = (Farm)this.farmMapper.selectById((Serializable)farmId);
        String farmMenu = "";
        if (ObjectUtil.isNotEmpty((Object)farm)) {
            farmMenu = farm.getFarmMenu();
        }
        if (userId == 1) {
            List menus = this.menuMapper.selectList(null);
            ArrayList<String> list = new ArrayList<String>();
            for (Menu menu : menus) {
                list.add(menu.getPermission());
            }
            return list;
        }
        String[] menus = farmMenu.split(",");
        return this.menuMapper.getMyButton(userId, menus);
    }

    public List getMyMenuMultilevel(String userId) {
        return null;
    }
}

