/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.farm.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.DataUill;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.farm.entity.FarmSale;
import com.huimv.admin.farm.entity.vo.AnalysisVo;
import com.huimv.admin.farm.mapper.FarmSaleMapper;
import com.huimv.admin.farm.service.IFarmSaleService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FarmSaleServiceImpl
extends ServiceImpl<FarmSaleMapper, FarmSale>
implements IFarmSaleService {
    @Autowired
    private FarmSaleMapper saleMapper;

    public Result listPage(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        String saleOrder = paramsMap.get("saleOrder");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).like(StringUtils.isNotBlank((CharSequence)saleOrder), (Object)"sale_order", (Object)saleOrder);
        return new Result(ResultCode.SUCCESS, (Object)this.saleMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    public Result add(FarmSale sale) {
        Integer count = this.saleMapper.selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"farm_id", (Object)sale.getFarmId())).eq((Object)"sale_order", (Object)sale.getSaleOrder()));
        if (count > 0) {
            return new Result(Integer.valueOf(10001), "\u65b0\u589e\u5931\u8d25\uff0c\u8ba2\u5355\u53f7\u5df2\u5b58\u5728\uff01", false);
        }
        return new Result(ResultCode.SUCCESS, (Object)this.saleMapper.insert((Object)sale));
    }

    public Result edit(FarmSale sale) {
        return new Result(ResultCode.SUCCESS, (Object)this.saleMapper.updateById((Object)sale));
    }

    public Result remove(Map<String, String> paramsMap) {
        String[] split;
        String ids = paramsMap.get("ids");
        for (String s : split = ids.split(",")) {
            this.saleMapper.deleteById((Serializable)((Object)s));
        }
        return new Result(ResultCode.SUCCESS);
    }

    public Result moneyCount(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        QueryWrapper queryWrapper = new QueryWrapper();
        Date yearStartTime = DataUill.getCurrentYearStartTime();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).ge((Object)"buy_time", (Object)yearStartTime);
        return new Result(ResultCode.SUCCESS, (Object)this.saleMapper.moneyCount(queryWrapper));
    }

    public Result listAnalysis(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String month = paramsMap.get("month");
        String endMonth = "";
        endMonth = month;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if ("".equals(month) || null == month) {
            Date monthmorning = DataUill.getTimesMonthmorning();
            month = sdf.format(monthmorning);
            DateTime endOfMonth = DateUtil.endOfMonth((Date)new Date());
            endMonth = sdf.format((Date)endOfMonth);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).between((Object)"sale_time", (Object)(month + "-01 00:00:00"), (Object)(endMonth + "-31 23:59:59"));
        return new Result(ResultCode.SUCCESS, (Object)this.saleMapper.analysis(queryWrapper));
    }

    public Result listSaleAnalysis(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String year = paramsMap.get("year");
        QueryWrapper queryWrapper = new QueryWrapper();
        DateTime dateTime = DateUtil.beginOfYear((Date)new Date());
        queryWrapper.eq((Object)"farm_id", (Object)farmId);
        if ("".equals(year) || null == year) {
            queryWrapper.ge((Object)"sale_time", (Object)dateTime);
        } else {
            queryWrapper.between((Object)"sale_time", (Object)(year + "-01-01 00:00:00"), (Object)(year + "-12-31 23:59:59"));
        }
        return new Result(ResultCode.SUCCESS, (Object)this.saleMapper.saleAnalysis(queryWrapper));
    }

    public Result listDetail(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).orderByDesc((Object)"sale_time");
        return new Result(ResultCode.SUCCESS, (Object)this.saleMapper.selectList((Wrapper)queryWrapper));
    }

    public Result listBySale(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        DateTime dateTime = DateUtil.beginOfYear((Date)new Date());
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).ge((Object)"sale_time", (Object)dateTime);
        List saleVos = this.saleMapper.listBySale(queryWrapper);
        return new Result(ResultCode.SUCCESS, (Object)saleVos);
    }

    public Result listByTime(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        DateTime dateTime = DateUtil.beginOfYear((Date)new Date());
        Date startTime = DataUill.getLastYearStartTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).ge((Object)"sale_time", (Object)dateTime);
        List analysisVos = this.saleMapper.litsByTime(queryWrapper);
        String lastYear = sdf.format(startTime);
        QueryWrapper queryWrapper1 = new QueryWrapper();
        ((QueryWrapper)queryWrapper1.eq((Object)"farm_id", (Object)farmId)).between((Object)"sale_time", (Object)(lastYear + "-01-01 00:00:00"), (Object)(lastYear + "-12-31 23:59:59"));
        List analysisVos1 = this.saleMapper.litsByTime(queryWrapper1);
        JSONArray jsonArray = new JSONArray();
        for (int i = 1; i < 13; ++i) {
            int month;
            Calendar calendar;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("time", (Object)(i + "\u6708"));
            jsonObject.put("value1", (Object)"--");
            jsonObject.put("value2", (Object)"--");
            for (AnalysisVo analysisVo : analysisVos1) {
                calendar = Calendar.getInstance();
                calendar.setTime(analysisVo.getCreateTime());
                month = calendar.get(2) + 1;
                if (month != i) continue;
                jsonObject.put("value1", (Object)analysisVo.getValues());
            }
            for (AnalysisVo analysisVo : analysisVos) {
                calendar = Calendar.getInstance();
                calendar.setTime(analysisVo.getCreateTime());
                month = calendar.get(2) + 1;
                if (month != i) continue;
                jsonObject.put("value2", (Object)analysisVo.getValues());
            }
            jsonArray.add((Object)jsonObject);
        }
        return new Result(ResultCode.SUCCESS, (Object)jsonArray);
    }
}

