/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.farm.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.farm.entity.FarmPurchase;
import com.huimv.admin.farm.mapper.FarmPurchaseMapper;
import com.huimv.admin.farm.service.IFarmPurchaseService;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FarmPurchaseServiceImpl
extends ServiceImpl<FarmPurchaseMapper, FarmPurchase>
implements IFarmPurchaseService {
    @Autowired
    private FarmPurchaseMapper purchaseMapper;

    public Result listPage(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        String order = paramsMap.get("order");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).like(StringUtils.isNotBlank((CharSequence)order), (Object)"order", (Object)order);
        return new Result(ResultCode.SUCCESS, (Object)this.purchaseMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    public Result add(FarmPurchase purchase) {
        return new Result(ResultCode.SUCCESS, (Object)this.purchaseMapper.insert((Object)purchase));
    }

    public Result edit(FarmPurchase purchase) {
        return new Result(ResultCode.SUCCESS, (Object)this.purchaseMapper.updateById((Object)purchase));
    }

    public Result remove(Map<String, String> paramsMap) {
        String[] split;
        String ids = paramsMap.get("ids");
        for (String s : split = ids.split(",")) {
            this.purchaseMapper.deleteById((Serializable)((Object)s));
        }
        return new Result(ResultCode.SUCCESS);
    }

    public Result listAnalysis(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String year = paramsMap.get("year");
        QueryWrapper queryWrapper = new QueryWrapper();
        DateTime dateTime = DateUtil.beginOfYear((Date)new Date());
        queryWrapper.eq((Object)"farm_id", (Object)farmId);
        if ("".equals(year) || null == year) {
            queryWrapper.ge((Object)"purchase_time", (Object)dateTime);
        } else {
            queryWrapper.between((Object)"purchase_time", (Object)(year + "-01-01 00:00:00"), (Object)(year + "-12-31 23:59:59"));
        }
        return new Result(ResultCode.SUCCESS, (Object)this.purchaseMapper.analysis(queryWrapper));
    }
}

