/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.cooperate.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.DataUill;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.cooperate.entity.CooperateProfit;
import com.huimv.admin.cooperate.mapper.CooperateProfitMapper;
import com.huimv.admin.cooperate.service.ICooperateProfitService;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CooperateProfitServiceImpl
extends ServiceImpl<CooperateProfitMapper, CooperateProfit>
implements ICooperateProfitService {
    @Autowired
    private CooperateProfitMapper profitMapper;

    public Result listPage(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"farm_id", (Object)farmId);
        return new Result(ResultCode.SUCCESS, (Object)this.profitMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    public Result add(CooperateProfit profit) {
        return new Result(ResultCode.SUCCESS, (Object)this.profitMapper.insert((Object)profit));
    }

    public Result edit(CooperateProfit profit) {
        return new Result(ResultCode.SUCCESS, (Object)this.profitMapper.updateById((Object)profit));
    }

    public Result remove(Map<String, String> paramsMap) {
        String[] split;
        String ids = paramsMap.get("ids");
        for (String s : split = ids.split(",")) {
            this.profitMapper.deleteById((Serializable)((Object)s));
        }
        return new Result(ResultCode.SUCCESS);
    }

    public Result profitCount(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        QueryWrapper queryWrapper = new QueryWrapper();
        Date yearStartTime = DataUill.getCurrentYearStartTime();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).ge((Object)"profit_time", (Object)yearStartTime);
        return new Result(ResultCode.SUCCESS, (Object)this.profitMapper.profitCount(queryWrapper));
    }

    public Result listScreen(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        DateTime dateTime = DateUtil.beginOfYear((Date)new Date());
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).ge((Object)"profit_time", (Object)dateTime);
        List profits = this.profitMapper.selectList((Wrapper)queryWrapper);
        Date yearStartTime = DataUill.getLastYearStartTime();
        QueryWrapper queryWrapper1 = new QueryWrapper();
        ((QueryWrapper)queryWrapper1.eq((Object)"farm_id", (Object)farmId)).between((Object)"profit_time", (Object)yearStartTime, (Object)dateTime);
        List profit2 = this.profitMapper.selectList((Wrapper)queryWrapper1);
        double moneyCount = 0.0;
        double lastYearCount = 0.0;
        JSONObject jsonObject = new JSONObject();
        if (profits.size() != 0) {
            for (CooperateProfit profit : profits) {
                moneyCount += Double.valueOf(profit.getProfitMoney()).doubleValue();
            }
            DecimalFormat def = new DecimalFormat("0.00");
            double a = moneyCount / (double)profits.size();
            jsonObject.put("yearCount", (Object)moneyCount);
            jsonObject.put("peopleCount", (Object)def.format(a));
            jsonObject.put("number", (Object)profits.size());
            if (profit2.size() == 0) {
                jsonObject.put("rank", (Object)"100.00");
            } else {
                for (CooperateProfit profit : profit2) {
                    lastYearCount += Double.valueOf(profit.getProfitMoney()).doubleValue();
                }
                double b = (moneyCount - lastYearCount) / lastYearCount * 100.0;
                jsonObject.put("rank", (Object)def.format(b));
            }
        }
        return new Result(ResultCode.SUCCESS, (Object)jsonObject);
    }

    public Result listCollective(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        DateTime dateTime = DateUtil.beginOfYear((Date)new Date());
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).ge((Object)"profit_time", (Object)dateTime);
        return new Result(ResultCode.SUCCESS, (Object)this.profitMapper.listCollective(queryWrapper));
    }

    public Result listType(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        List profits = this.profitMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"farm_id", (Object)farmId));
        Integer type = 2;
        Integer number1 = 0;
        Integer number2 = 0;
        if (profits.size() != 0) {
            for (CooperateProfit profit : profits) {
                if (profit.getProject() == 0) {
                    number1 = number1 + 1;
                    continue;
                }
                number2 = number2 + 1;
            }
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)profits.size());
        jsonObject.put("type", (Object)type);
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("name", (Object)"\u52a1\u5de5");
        jsonObject1.put("value", (Object)number1);
        jsonArray.add((Object)jsonObject1);
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("name", (Object)"\u6709\u673a\u80a5");
        jsonObject2.put("value", (Object)number2);
        jsonArray.add((Object)jsonObject2);
        jsonObject.put("list", (Object)jsonArray);
        return new Result(ResultCode.SUCCESS, (Object)jsonObject);
    }
}

