/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.huimv.admin.common.token.TokenSign;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.entity.Group;
import com.huimv.admin.service.IAccountGroupService;
import com.huimv.admin.service.IGroupService;
import com.huimv.admin.service.ISysAccountMultilevelService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/group"})
@CrossOrigin
public class SysGroupController {
    @Autowired
    private IGroupService groupService;
    @Autowired
    private IAccountGroupService accountGroupService;
    @Autowired
    private ISysAccountMultilevelService accountMultilevelService;

    @PostMapping(value={"/add"})
    public Result addGroup(@RequestBody Group group, HttpServletRequest request) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        return this.groupService.addGroup(group, userId);
    }

    @PostMapping(value={"/edit"})
    public Result updateGroup(@RequestBody Group group) {
        return this.groupService.updateGroup(group);
    }

    @RequestMapping(value={"/remove"})
    public Result removeGroup(@RequestParam(value="groupId") Integer groupId) {
        this.accountGroupService.remove((Wrapper)new QueryWrapper().in((Object)"group_id", new Object[]{groupId}));
        return this.groupService.removeGroup(groupId);
    }

    @PostMapping(value={"/list"})
    public Result listGroup(@RequestBody Map map, HttpServletRequest request) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        List allChildId = this.accountMultilevelService.getAllChildId(userId);
        return this.groupService.listGroup(map, allChildId);
    }

    @PostMapping(value={"/getGroupByUserId"})
    public Result getGroupByUserId(@RequestBody Map map) {
        Integer userId = (Integer)map.get("userId");
        return this.groupService.getGroupByUserId(userId);
    }
}

