/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.huimv.admin.common.token.TokenSign;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.common.utils.UploadImage;
import com.huimv.admin.entity.SysAccountMultilevel;
import com.huimv.admin.service.IAccountGroupService;
import com.huimv.admin.service.ISysAccountMultilevelService;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@CrossOrigin
@RestController
@RequestMapping(value={"/admin/accountMultilevel"})
public class SysAccountMultilevelController {
    @Autowired
    private ISysAccountMultilevelService accountMultilevelService;
    @Autowired
    private IAccountGroupService accountGroupService;
    @Autowired
    private UploadImage uploadImage;

    @PostMapping(value={"/list"})
    public Result list(@RequestBody Map map, HttpServletRequest request) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        int pageNum = (Integer)map.get("pageNum");
        int pageSize = (Integer)map.get("pageSize");
        String searchStr = (String)map.get("searchStr");
        return this.accountMultilevelService.findUserAccount(searchStr, pageNum, pageSize, userId);
    }

    @PostMapping(value={"/listSubordinate"})
    public Result listSubordinate(@RequestBody Map map, HttpServletRequest request) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        int pageNum = (Integer)map.get("pageNum");
        int pageSize = (Integer)map.get("pageSize");
        String searchStr = (String)map.get("searchStr");
        return this.accountMultilevelService.listSubordinate(searchStr, pageNum, pageSize, userId);
    }

    @PostMapping(value={"/listSubordinateByFarm"})
    public Result listSubordinateByFarm(@RequestBody Map map, HttpServletRequest request) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        String farmId = (String)map.get("farmId");
        return this.accountMultilevelService.listSubordinateByFarm(farmId, userId);
    }

    @PostMapping(value={"/add"})
    public Result add(@RequestBody SysAccountMultilevel sysAccountMultilevel, HttpServletRequest request) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        return this.accountMultilevelService.add(sysAccountMultilevel, userId);
    }

    @PostMapping(value={"/update"})
    public Result update(@RequestBody SysAccountMultilevel sysAccountMultilevel) {
        this.accountMultilevelService.updateById((Object)sysAccountMultilevel);
        return new Result(Integer.valueOf(10000), "\u4fee\u6539\u6210\u529f", true);
    }

    @GetMapping(value={"/remove"})
    public Result remove(@RequestParam(name="userIds") List<Integer> userIds) {
        this.accountGroupService.remove((Wrapper)new QueryWrapper().in((Object)"account_id", userIds));
        this.accountMultilevelService.removeByIds(userIds);
        return new Result(Integer.valueOf(10000), "\u5220\u9664\u6210\u529f", true);
    }

    @GetMapping(value={"/setAccountStatus"})
    public Result setAccountStatus(@RequestParam(name="ids") List<Integer> ids, @RequestParam(name="status") Integer status) {
        return this.accountMultilevelService.setAccountStatus(ids, status);
    }

    @GetMapping(value={"/findOne"})
    public Result findOne(Integer id) {
        return new Result(ResultCode.SUCCESS, this.accountMultilevelService.getById((Serializable)id));
    }

    @GetMapping(value={"/getLastFarmId"})
    public Result getLastFarmId(HttpServletRequest request) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        return this.accountMultilevelService.getLastFarmId(userId);
    }

    @PostMapping(value={"/editImg"})
    @Transactional(rollbackFor={Exception.class})
    public Result editImg(HttpServletRequest httpServletRequest, @RequestParam(value="img") MultipartFile img) throws IOException {
        SysAccountMultilevel sysAccountMultilevel = (SysAccountMultilevel)this.accountMultilevelService.getById((Serializable)TokenSign.getMemberIdByJwtToken((HttpServletRequest)httpServletRequest));
        if (this.uploadImage.getImageCom(img).equals("\u4e0a\u4f20\u5931\u8d25")) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new Result(Integer.valueOf(10001), "\u56fe\u7247\u4e0a\u4f20\u5931\u8d25", false);
        }
        sysAccountMultilevel.setImgUrl(this.uploadImage.getImageCom(img));
        this.accountMultilevelService.updateById((Object)sysAccountMultilevel);
        return Result.SUCCESS();
    }

    @PostMapping(value={"/updateUserName"})
    public Result updateUserName(HttpServletRequest httpServletRequest, @RequestBody Map<String, String> paramsMap) {
        SysAccountMultilevel sysAccountMultilevel = (SysAccountMultilevel)this.accountMultilevelService.getById((Serializable)TokenSign.getMemberIdByJwtToken((HttpServletRequest)httpServletRequest));
        sysAccountMultilevel.setUserName(paramsMap.get("userName"));
        this.accountMultilevelService.updateById((Object)sysAccountMultilevel);
        return Result.SUCCESS();
    }

    @PostMapping(value={"/updateUser"})
    public Result updateUser(HttpServletRequest httpServletRequest, @RequestParam(value="img", required=false) MultipartFile img, @RequestParam(value="userName", required=false) String userName, @RequestParam(value="phone", required=false) String phone) throws IOException {
        return this.accountMultilevelService.updateUser(httpServletRequest, img, userName, phone);
    }

    @PostMapping(value={"/getDetail"})
    public Result getDetail(HttpServletRequest httpServletRequest) {
        return new Result(ResultCode.SUCCESS, this.accountMultilevelService.getById((Serializable)TokenSign.getMemberIdByJwtToken((HttpServletRequest)httpServletRequest)));
    }
}

