/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.ProtSheepInfo;
import com.huimv.admin.entity.SheepEarmark;
import com.huimv.admin.service.IProtSheepInfoService;
import com.huimv.admin.service.ISheepEarmarkService;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/prot-sheep-info"})
@CrossOrigin
public class ProtSheepInfoController {
    @Autowired
    private IProtSheepInfoService sheepInfoService;
    @Autowired
    private ISheepEarmarkService earmarkService;

    @RequestMapping(value={"/listPage"})
    public Result listPage(@RequestBody Map<String, String> paramsMap) {
        return this.sheepInfoService.listPage(paramsMap);
    }

    @RequestMapping(value={"/list"})
    public Result list(@RequestBody Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String sheepType = paramsMap.get("sheepType");
        String sex = paramsMap.get("sex");
        String isLeave = paramsMap.get("isLeave");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).eq(StringUtils.isNotBlank((CharSequence)sheepType), (Object)"sheep_type", (Object)sheepType)).eq(StringUtils.isNotBlank((CharSequence)sex), (Object)"sex", (Object)sex)).eq(StringUtils.isNotBlank((CharSequence)isLeave), (Object)"is_leave", (Object)isLeave);
        return new Result(ResultCode.SUCCESS, (Object)this.sheepInfoService.list((Wrapper)queryWrapper));
    }

    @RequestMapping(value={"/add"})
    public Result add(@RequestBody ProtSheepInfo protSheepInfo) throws ParseException {
        String sheepId = protSheepInfo.getSheepId();
        int count = this.sheepInfoService.count((Wrapper)new QueryWrapper().eq((Object)"sheep_id", (Object)sheepId));
        if (count > 0) {
            return new Result(Integer.valueOf(10001), "\u6dfb\u52a0\u5931\u8d25\uff0c\u7f8a\u53ea\u6863\u6848\u5df2\u5b58\u5728", false);
        }
        SheepEarmark earmark = (SheepEarmark)this.earmarkService.getOne((Wrapper)new QueryWrapper().eq((Object)"earmark", (Object)sheepId));
        if (ObjectUtil.isNotEmpty((Object)earmark)) {
            earmark.setIsUse(Integer.valueOf(1));
            this.earmarkService.updateById((Object)earmark);
        }
        Date date = new Date();
        protSheepInfo.setCreateTime(date);
        long l = date.getTime() - protSheepInfo.getBirthTime().getTime();
        long l1 = l / 86400000L;
        protSheepInfo.setSheepDay(Integer.valueOf((int)l1));
        this.sheepInfoService.save((Object)protSheepInfo);
        return new Result(Integer.valueOf(10000), "\u6dfb\u52a0\u6210\u529f", true);
    }

    @RequestMapping(value={"/remove"})
    public Result remove(@RequestBody Map<String, String> paramsMap) {
        String[] split;
        String ids = paramsMap.get("ids");
        for (String s : split = ids.split(",")) {
            SheepEarmark earmark;
            ProtSheepInfo sheepInfo = (ProtSheepInfo)this.sheepInfoService.getById((Serializable)((Object)s));
            if (StringUtils.isNotBlank((CharSequence)sheepInfo.getSheepId()) && ObjectUtil.isNotEmpty((Object)(earmark = (SheepEarmark)this.earmarkService.getOne((Wrapper)new QueryWrapper().eq((Object)"earmark", (Object)sheepInfo.getSheepId()))))) {
                earmark.setIsUse(Integer.valueOf(0));
                this.earmarkService.updateById((Object)earmark);
            }
            this.sheepInfoService.removeById((Serializable)((Object)s));
        }
        return new Result(Integer.valueOf(10000), "\u5220\u9664\u6210\u529f\uff01", true);
    }

    @RequestMapping(value={"/edit"})
    public Result edit(@RequestBody ProtSheepInfo protSheepInfo) {
        String sheepId = protSheepInfo.getSheepId();
        int count = this.sheepInfoService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"sheep_id", (Object)sheepId)).ne((Object)"id", (Object)protSheepInfo.getId()));
        if (count > 0) {
            return new Result(Integer.valueOf(10001), "\u4fee\u6539\u5931\u8d25\uff0c\u7f8a\u53ea\u6863\u6848\u5df2\u5b58\u5728", false);
        }
        this.sheepInfoService.updateById((Object)protSheepInfo);
        return new Result(Integer.valueOf(10000), "\u4fee\u6539\u6210\u529f\uff01", true);
    }

    @RequestMapping(value={"/sheepDetail"})
    public Result sheepDetail(@RequestBody Map<String, String> paramsMap) {
        return this.sheepInfoService.sheepDetail(paramsMap);
    }

    @RequestMapping(value={"/stockCount"})
    public Result stockCount(@RequestBody Map<String, String> paramsMap) {
        return this.sheepInfoService.stockCount(paramsMap);
    }

    @RequestMapping(value={"/sheepList"})
    public Result sheepList(@RequestBody Map<String, String> paramsMap) {
        return this.sheepInfoService.sheepList(paramsMap);
    }

    @RequestMapping(value={"/sheepInfoList"})
    public Result sheepInfoList(@RequestBody Map<String, String> paramsMap) {
        return this.sheepInfoService.sheepInfoList(paramsMap);
    }

    @RequestMapping(value={"/stockList"})
    public Result stockList(@RequestBody Map<String, String> paramsMap) {
        return this.sheepInfoService.stockList(paramsMap);
    }

    @RequestMapping(value={"/middleCount"})
    public Result middleCount(@RequestBody Map<String, String> paramsMap) {
        return this.sheepInfoService.middleCount(paramsMap);
    }

    @RequestMapping(value={"/listAct"})
    public Result listAct(@RequestBody Map<String, String> paramsMap) {
        return this.sheepInfoService.listAct(paramsMap);
    }

    @RequestMapping(value={"/listTemp"})
    public Result listTemp(@RequestBody Map<String, String> paramsMap) {
        return this.sheepInfoService.listTemp(paramsMap);
    }

    @RequestMapping(value={"/listWarning"})
    public String listWarning(@RequestBody Map<String, String> paramsMap) {
        return this.sheepInfoService.listWarning(paramsMap);
    }

    @RequestMapping(value={"/listWarning2"})
    public String listWarning2(@RequestBody Map<String, String> paramsMap) {
        return this.sheepInfoService.listWarning2(paramsMap);
    }

    @RequestMapping(value={"/pedigree"})
    public Result pedigree(@RequestBody Map<String, String> paramsMap) {
        return this.sheepInfoService.pedigree(paramsMap);
    }
}

