/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.huimv.admin.common.token.TokenSign;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.Farm;
import com.huimv.admin.entity.dto.WeatherDto;
import com.huimv.admin.service.IFarmService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/admin/farm"})
public class FarmController {
    @Autowired
    private IFarmService farmService;

    @GetMapping(value={"/getFarm"})
    public Result getFarm(HttpServletRequest request) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        return this.farmService.getFarm(userId);
    }

    @GetMapping(value={"/getFarm2"})
    public Result getFarm2(HttpServletRequest request) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        return this.farmService.getFarm2(userId);
    }

    @PostMapping(value={"/list"})
    public Result list(HttpServletRequest request, @RequestBody Map paramMap) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        return this.farmService.listPage(userId, paramMap);
    }

    @PostMapping(value={"/add"})
    public Result add(@RequestBody Farm farm, HttpServletRequest request) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        if (userId != 1) {
            return new Result(Integer.valueOf(10001), "\u8be5\u8d26\u53f7\u4e0d\u80fd\u64cd\u4f5c\u7267\u573a", false);
        }
        return this.farmService.add(farm);
    }

    @PostMapping(value={"/edit"})
    public Result edit(@RequestBody Farm farm, HttpServletRequest request) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        if (userId != 1) {
            return new Result(Integer.valueOf(10001), "\u8be5\u8d26\u53f7\u4e0d\u80fd\u64cd\u4f5c\u7267\u573a", false);
        }
        farm.setLocation(farm.getFrontLocation());
        this.farmService.updateById((Object)farm);
        return new Result(Integer.valueOf(10000), "\u4fee\u6539\u6210\u529f", true);
    }

    @GetMapping(value={"/remove"})
    public Result remove(@RequestParam(name="ids") List<Integer> ids, HttpServletRequest request) {
        Integer userId = TokenSign.getMemberIdByJwtToken((HttpServletRequest)request);
        if (userId != 1) {
            return new Result(Integer.valueOf(10001), "\u8be5\u8d26\u53f7\u4e0d\u80fd\u64cd\u4f5c\u7267\u573a", false);
        }
        this.farmService.removeByIds(ids);
        return new Result(Integer.valueOf(10000), "\u5220\u9664\u6210\u529f", true);
    }

    @PostMapping(value={"/getWeather"})
    public Result getWeather(@RequestBody Map<String, Integer> map) {
        int farmId = map.get("farmId");
        Farm byId = (Farm)this.farmService.getById((Serializable)Integer.valueOf(farmId));
        String cityCode = byId.getLocation();
        if (ObjectUtil.isEmpty((Object)cityCode)) {
            cityCode = "330782";
        }
        String url = "https://restapi.amap.com/v3/weather/weatherInfo?parameters&key=c1d8179ed2dda7ed48c56bed06c0c86e&city=" + cityCode + "&extensions=base&output=JSON";
        String result = HttpUtil.get((String)url);
        WeatherDto weatherDto = (WeatherDto)JSONUtil.toBean((String)result, WeatherDto.class);
        return new Result(ResultCode.SUCCESS, (Object)weatherDto);
    }
}

