/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.controller;

import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.service.IAuthorizeService;
import com.huimv.admin.service.IMenuService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/auth"})
@CrossOrigin
public class AuthorizeController {
    @Autowired
    IAuthorizeService iAuthorizeService;
    @Autowired
    IMenuService iMenuService;

    @PostMapping(value={"/saveAccountGroup"})
    public Result saveAccountGroup(@RequestBody Map<String, String> map) {
        String accountId = map.get("accountId");
        String groupIds = map.get("groupIds");
        return this.iAuthorizeService.saveAccountGroup(accountId, groupIds);
    }

    @PostMapping(value={"/saveGroupMenu"})
    public Result saveGroupMenu(@RequestBody Map<String, String> map) {
        String groupId = map.get("groupId");
        String menuIds = map.get("menuIds");
        String isAll = map.get("isAll");
        return this.iAuthorizeService.saveGroupMenu(groupId, menuIds, isAll);
    }

    @RequestMapping(value={"/getGroupByAccount"})
    public Result getGroupByAccount(@RequestParam(name="accountId", required=true) String accountId) {
        return this.iAuthorizeService.getGroupByAccount(accountId);
    }

    @PostMapping(value={"/getMenuByGroup"})
    public Result getMenuByGroup(@RequestBody Map<String, String> map) {
        return this.iAuthorizeService.getMenuByGroup(map);
    }

    @PostMapping(value={"/getMenuByGroupAndFarm"})
    public Result getMenuByGroupAndFarm(@RequestBody Map<String, String> map) {
        return this.iAuthorizeService.getMenuByGroupAndFarm(map);
    }

    @PostMapping(value={"/getMyMenu"})
    public Result getMyMenuAndButton(@RequestBody Map<String, String> map) {
        String userId = map.get("userId");
        String farmId = map.get("farmId");
        List myMenu = this.iAuthorizeService.getMyMenuAll(userId, farmId);
        List list = this.iMenuService.optimizeListUtil(0, myMenu);
        return new Result(ResultCode.SUCCESS, (Object)list);
    }

    @PostMapping(value={"/getMyButton"})
    public Result getMyButton(@RequestBody Map<String, Integer> map) {
        Integer userId = map.get("userId");
        Integer farmId = map.get("farmId");
        List list = this.iAuthorizeService.getMyButton(userId, farmId);
        return new Result(ResultCode.SUCCESS, (Object)list);
    }

    @GetMapping(value={"/getAcountByGroup"})
    public Result getAccountByGroup(String groupId) {
        return this.iAuthorizeService.getAccountByGroup(groupId);
    }
}

