/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.config;

import com.alibaba.fastjson.JSONObject;
import com.huimv.admin.common.token.TokenConstant;
import com.huimv.admin.common.token.TokenSign;
import io.jsonwebtoken.Claims;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class JWTInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        response.setContentType("application/json;charset=utf-8");
        String token = request.getHeader("accessToken");
        if (null == token) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("data", "token is null");
            map.put("code", "401");
            response.setStatus(401);
            response.getWriter().write(JSONObject.toJSONString(map));
            return false;
        }
        Claims claims = TokenSign.getClaims((String)token);
        if (claims == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("data", "token is overdue");
            map.put("code", "403");
            response.setStatus(403);
            response.getWriter().write(JSONObject.toJSONString(map));
            return false;
        }
        boolean result = TokenSign.verify((String)token);
        if (result) {
            TokenConstant.updateTokenMap((String)token);
            return true;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("data", "token is null");
        map.put("code", "401");
        response.setStatus(401);
        response.getWriter().write(JSONObject.toJSONString(map));
        return false;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

