/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.common.utils;

import cn.hutool.core.date.DateTime;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class DateUtil {
    public int getNowHour() {
        Calendar cal = Calendar.getInstance();
        return cal.get(11);
    }

    public int setCalendarNewTime(String newTime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(newTime));
        return cal.get(11);
    }

    public int setCalendarNewTime(Timestamp newTime) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(newTime);
        return cal.get(11);
    }

    public String formatLongToDate(Long longDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(longDate);
        return df.format(date);
    }

    public String getThisYear() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        return String.valueOf(year);
    }

    public String getThisMonth() {
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2) + 1;
        if (String.valueOf(month).length() == 1) {
            return "0" + String.valueOf(month);
        }
        return String.valueOf(month);
    }

    public String formatDateTime(String dateText) throws ParseException {
        if (dateText.indexOf("T") != -1) {
            dateText = dateText.replace("T", " ");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf.parse(dateText);
        return sdf.format(date);
    }

    public String formatDateText(String dateText) throws ParseException {
        if (dateText.indexOf("T") != -1) {
            dateText = dateText.replace("T", " ");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = sdf.parse(dateText);
        return sdf.format(date);
    }

    public Date parseDateTime(String dateText) throws ParseException {
        if (dateText.indexOf("T") != -1) {
            dateText = dateText.replace("T", " ");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.parse(dateText);
    }

    public Date parseDate(String dateText) throws ParseException {
        if (dateText.indexOf("T") != -1) {
            dateText = dateText.replace("T", " ");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.parse(dateText);
    }

    public Long parseDateTimeTextToLong(String dateText) throws ParseException {
        if (dateText.indexOf("T") != -1) {
            dateText = dateText.replace("T", " ");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf.parse(dateText);
        return date.getTime();
    }

    public Long parseDateTextToLong(String dateText) throws ParseException {
        if (dateText.indexOf("T") != -1) {
            dateText = dateText.replace("T", " ");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = sdf.parse(dateText);
        return date.getTime();
    }

    public Date getTodayDate() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.parse(sdf.format(new Date()));
    }

    public Date getTodayDatetime() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.parse(sdf.format(new Date()));
    }

    public String getTodayDateText() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date());
    }

    public java.sql.Date getTodayMySQLDate() {
        java.sql.Date todayDate = new java.sql.Date(new Date().getTime());
        return todayDate;
    }

    public Timestamp getTimestamp() {
        Timestamp nowTimestamp = new Timestamp(new Date().getTime());
        return nowTimestamp;
    }

    public String getTodayText() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    public String formatDateText(Date date) throws ParseException {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public String formatDatetimeText(Date date) throws ParseException {
        if (date == null || date.toString().length() == 0) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public String getNowText() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(new Date());
    }

    public String getTodayMissionText() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(new Date());
    }

    public String getStartDateInThisMonth() {
        DateTime date = cn.hutool.core.date.DateUtil.date();
        return (cn.hutool.core.date.DateUtil.beginOfMonth((Date)date) + "").substring(0, 10);
    }

    public String getEndDateInThisMonth() {
        DateTime date = cn.hutool.core.date.DateUtil.date();
        return (date + "").substring(0, 10);
    }

    public ArrayList<String> test(int intervals) {
        ArrayList<String> pastDaysList = new ArrayList<String>();
        ArrayList<String> fetureDaysList = new ArrayList<String>();
        for (int i = 0; i < intervals; ++i) {
            pastDaysList.add(this.getPastDate(i));
            fetureDaysList.add(this.getFetureDate(i));
        }
        return pastDaysList;
    }

    public ArrayList<String> getPastIntervals(int intervals) {
        ArrayList<String> pastDaysList = new ArrayList<String>();
        for (int i = 0; i < intervals; ++i) {
            pastDaysList.add(this.getPastDate(i));
        }
        return pastDaysList;
    }

    public ArrayList<String> getPastIntervalsASC(int intervals) {
        ArrayList<String> pastDaysList = new ArrayList<String>();
        for (int i = intervals - 1; i >= 0; --i) {
            pastDaysList.add(this.getPastDate(i));
        }
        return pastDaysList;
    }

    public ArrayList<String> getFetureIntervals(int intervals) {
        ArrayList<String> fetureDaysList = new ArrayList<String>();
        for (int i = 0; i < intervals; ++i) {
            fetureDaysList.add(this.getFetureDate(i));
        }
        return fetureDaysList;
    }

    public String getPastDate(int past) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) - past);
        Date today = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String result = format.format(today);
        return result;
    }

    public String getFetureDate(int past) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) + past);
        Date today = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String result = format.format(today);
        return result;
    }

    public String rebuildDateTime(String text) {
        return text.substring(0, 4) + "-" + text.substring(4, 6) + "-" + text.substring(6, 8) + " " + text.substring(8, 10) + ":" + text.substring(10, 12) + ":" + text.substring(12, 14);
    }

    public static void main(String[] args) {
        DateUtil du = new DateUtil();
        ArrayList pastList = du.getPastIntervalsASC(5);
        for (String pastDate : pastList) {
            System.out.println("pastDate>>" + pastDate);
        }
        ArrayList fetureList = du.getFetureIntervals(5);
        for (String fetureDate : fetureList) {
            System.out.println("fetureDate>>" + fetureDate);
        }
    }

    private void test1() {
        String text = "20211201104300";
        String date = text.substring(0, 4) + "-" + text.substring(4, 6) + "-" + text.substring(6, 8) + " " + text.substring(8, 10) + ":" + text.substring(10, 12) + ":" + text.substring(12, 14);
        System.out.println("date=" + date);
    }

    public Long getNowLong() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5) - 1, 0, 0, 0);
        return calendar.getTime().getTime();
    }
}

