/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.DataUill;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.ProtWarning;
import com.huimv.admin.mapper.ProtWarningMapper;
import com.huimv.admin.service.IProtWarningService;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProtWarningServiceImpl
extends ServiceImpl<ProtWarningMapper, ProtWarning>
implements IProtWarningService {
    @Autowired
    private ProtWarningMapper warningMapper;

    public Result listWarningType(Map<String, String> paramsMap) {
        String warningType = paramsMap.get("warningType");
        String farmId = paramsMap.get("farmId");
        String timeType = paramsMap.get("timeType");
        String unitId = paramsMap.get("unitId");
        String startTime = paramsMap.get("startTime");
        String endTime = paramsMap.get("endTime");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        if ("".equals(timeType) || null == timeType) {
            timeType = "1";
        }
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).eq(StringUtils.isNotBlank((CharSequence)warningType), (Object)"warning_type", (Object)warningType);
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)unitId), (Object)"unit_id", (Object)unitId);
        if ("1".equals(timeType)) {
            Date timesmorning = DataUill.getTimesmorning();
            queryWrapper.ge((Object)"create_time", (Object)timesmorning);
        } else if ("2".equals(timeType)) {
            DateTime dateTime = DateUtil.beginOfWeek((Date)new Date());
            queryWrapper.ge((Object)"create_time", (Object)dateTime);
        } else if ("3".equals(timeType)) {
            Date monthmorning = DataUill.getTimesMonthmorning();
            queryWrapper.ge((Object)"create_time", (Object)monthmorning);
        } else if ("4".equals(timeType)) {
            queryWrapper.between((Object)"create_time", (Object)startTime, (Object)endTime);
        }
        return new Result(ResultCode.SUCCESS, (Object)this.warningMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    public Result warningAnalysis(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String timeType = paramsMap.get("timeType");
        if ("".equals(timeType) || null == timeType) {
            timeType = "2";
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"farm_id", (Object)farmId);
        if ("1".equals(timeType)) {
            Date timesmorning = DataUill.getTimesmorning();
            queryWrapper.ge((Object)"create_time", (Object)timesmorning);
        } else if ("2".equals(timeType)) {
            DateTime dateTime = DateUtil.beginOfWeek((Date)new Date());
            queryWrapper.ge((Object)"create_time", (Object)dateTime);
        } else if ("3".equals(timeType)) {
            DateTime dateTime = DateUtil.beginOfMonth((Date)new Date());
            queryWrapper.ge((Object)"create_time", (Object)dateTime);
        } else if ("4".equals(timeType)) {
            String startTime = paramsMap.get("startTime");
            String endTime = paramsMap.get("entTime");
            queryWrapper.between((Object)"create_time", (Object)startTime, (Object)endTime);
        }
        return new Result(ResultCode.SUCCESS, (Object)this.warningMapper.warningAnalysis(queryWrapper));
    }
}

