/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.DataUill;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.ProtProduction;
import com.huimv.admin.mapper.ProtProductionMapper;
import com.huimv.admin.service.IProtProductionService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProtProductionServiceImpl
extends ServiceImpl<ProtProductionMapper, ProtProduction>
implements IProtProductionService {
    @Autowired
    private ProtProductionMapper productionMapper;

    public Result listPage(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        String unitName = paramsMap.get("unitName");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).like(StringUtils.isNotBlank((CharSequence)unitName), (Object)"unit_name", (Object)unitName);
        return new Result(ResultCode.SUCCESS, (Object)this.productionMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    public Result add(ProtProduction production) {
        production.setCreateTime(new Date());
        return new Result(ResultCode.SUCCESS, (Object)this.productionMapper.insert((Object)production));
    }

    public Result edit(ProtProduction production) {
        return new Result(ResultCode.SUCCESS, (Object)this.productionMapper.updateById((Object)production));
    }

    public Result remove(Map<String, String> paramsMap) {
        String[] split;
        String ids = paramsMap.get("ids");
        for (String s : split = ids.split(",")) {
            this.productionMapper.deleteById((Serializable)((Object)s));
        }
        return new Result(ResultCode.SUCCESS);
    }

    public Result typeAnalysis(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String month = paramsMap.get("month");
        String endMonth = "";
        endMonth = month;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if ("".equals(month) || null == month) {
            Date monthmorning = DataUill.getTimesMonthmorning();
            month = sdf.format(monthmorning);
            DateTime endOfMonth = DateUtil.endOfMonth((Date)new Date());
            endMonth = sdf.format((Date)endOfMonth);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).between((Object)"create_time", (Object)(month + "-01 00:00:00"), (Object)(endMonth + "-31 23:59:59"));
        return new Result(ResultCode.SUCCESS, (Object)this.productionMapper.typeAnalysis(queryWrapper));
    }

    public Result analysis(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String year = paramsMap.get("year");
        QueryWrapper queryWrapper = new QueryWrapper();
        DateTime dateTime = DateUtil.beginOfYear((Date)new Date());
        queryWrapper.eq((Object)"farm_id", (Object)farmId);
        if ("".equals(year) || null == year) {
            queryWrapper.ge((Object)"create_time", (Object)dateTime);
        } else {
            queryWrapper.between((Object)"create_time", (Object)(year + "-01-01 00:00:00"), (Object)(year + "-12-31 23:59:59"));
        }
        return new Result(ResultCode.SUCCESS, (Object)this.productionMapper.analysis(queryWrapper));
    }
}

