/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.AccountGroup;
import com.huimv.admin.entity.GroupMenu;
import com.huimv.admin.entity.Menu;
import com.huimv.admin.mapper.AccountGroupMapper;
import com.huimv.admin.mapper.GroupMenuMapper;
import com.huimv.admin.mapper.MenuMapper;
import com.huimv.admin.service.IMenuService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuServiceImpl
extends ServiceImpl<MenuMapper, Menu>
implements IMenuService {
    @Autowired
    private MenuMapper menuMapper;
    @Autowired
    private AccountGroupMapper accountGroupMapper;
    @Autowired
    private GroupMenuMapper groupMenuMapper;

    public Result addMenu(Menu menu, Integer userId) {
        try {
            if (menu == null) {
                return new Result(Integer.valueOf(10002), "\u53c2\u6570\u9519\u8bef", false);
            }
            this.menuMapper.insert((Object)menu);
            Integer id = menu.getId();
            List accounts = this.accountGroupMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"account_id", (Object)userId));
            for (AccountGroup account : accounts) {
                GroupMenu groupMenu = new GroupMenu();
                groupMenu.setGroupId(account.getGroupId());
                groupMenu.setMenuId(id);
                this.groupMenuMapper.insert((Object)groupMenu);
            }
            return new Result(Integer.valueOf(10000), "\u6dfb\u52a0\u6210\u529f", true);
        }
        catch (Exception e) {
            return new Result(Integer.valueOf(10001), "\u6dfb\u52a0\u5931\u8d25", false);
        }
    }

    public Result editMenu(Menu menu) {
        try {
            if (menu.getId() == null) {
                return new Result(Integer.valueOf(10002), "\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u83dc\u5355", false);
            }
            this.menuMapper.updateById((Object)menu);
            return new Result(Integer.valueOf(10000), "\u4fee\u6539\u6210\u529f", true);
        }
        catch (Exception e) {
            return new Result(Integer.valueOf(10001), "\u4fee\u6539\u5931\u8d25", false);
        }
    }

    public Result removeMenu(Integer menuId) {
        try {
            QueryWrapper menuQueryWrapper = new QueryWrapper();
            menuQueryWrapper.eq((Object)"parent_id", (Object)menuId);
            List lists = this.menuMapper.selectList((Wrapper)menuQueryWrapper);
            if (lists != null && lists.size() > 0) {
                for (Menu menu : lists) {
                    this.removeMenu(menu.getId());
                    this.menuMapper.deleteById((Serializable)menu);
                }
            }
            this.menuMapper.deleteById((Serializable)menuId);
        }
        catch (Exception e) {
            return new Result(Integer.valueOf(10001), "\u5220\u9664\u5931\u8d25", false);
        }
        return new Result(Integer.valueOf(10000), "\u5220\u9664\u6210\u529f", true);
    }

    public Result optimizeList() {
        QueryWrapper menuQueryWrapper = new QueryWrapper();
        menuQueryWrapper.orderByAsc((Object)"sort");
        List all = this.menuMapper.selectList((Wrapper)menuQueryWrapper);
        List list = this.optimizeListUtil(0, all);
        return new Result(ResultCode.SUCCESS, (Object)list);
    }

    public Result list1() {
        QueryWrapper menuQueryWrapper = new QueryWrapper();
        menuQueryWrapper.orderByAsc((Object)"sort");
        menuQueryWrapper.eq((Object)"weight", (Object)0);
        List all = this.menuMapper.selectList((Wrapper)menuQueryWrapper);
        List list = this.optimizeListUtil(0, all);
        return new Result(ResultCode.SUCCESS, (Object)list);
    }

    public List<Map> optimizeListUtil(int parentId, List<Menu> menuEntityList) {
        ArrayList<Map> list = new ArrayList<Map>();
        for (Menu menuEntity : menuEntityList) {
            if (menuEntity.getParentId() != parentId) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", menuEntity.getId());
            map.put("title", menuEntity.getTitle());
            map.put("parentId", menuEntity.getParentId());
            map.put("url", menuEntity.getUrl());
            map.put("sort", menuEntity.getSort());
            map.put("value", menuEntity.getId());
            map.put("pid", menuEntity.getParentId());
            map.put("permission", menuEntity.getPermission());
            map.put("weight", menuEntity.getWeight());
            map.put("ifShow", menuEntity.getIfShow());
            if (this.menuEntityIsChildren(menuEntity, menuEntityList)) {
                map.put("children", this.optimizeListUtil(menuEntity.getId().intValue(), menuEntityList));
            } else {
                map.put("children", new ArrayList());
            }
            list.add(map);
        }
        return list;
    }

    private boolean menuEntityIsChildren(Menu menuEntity, List<Menu> menuEntityList) {
        for (Menu Menu2 : menuEntityList) {
            if (!menuEntity.getId().equals(Menu2.getParentId())) continue;
            return true;
        }
        return false;
    }
}

