/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.BreedTupping;
import com.huimv.admin.entity.ProtSheepInfo;
import com.huimv.admin.mapper.BreedTuppingMapper;
import com.huimv.admin.mapper.ProtSheepInfoMapper;
import com.huimv.admin.service.IBreedTuppingService;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BreedTuppingServiceImpl
extends ServiceImpl<BreedTuppingMapper, BreedTupping>
implements IBreedTuppingService {
    @Autowired
    private BreedTuppingMapper tuppingMapper;
    @Autowired
    private ProtSheepInfoMapper sheepInfoMapper;

    public Result listPage(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        String sheepId = paramsMap.get("sheepId");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        QueryWrapper sheepInfoQueryWrapper = new QueryWrapper();
        ((QueryWrapper)sheepInfoQueryWrapper.eq((Object)"farm_id", (Object)farmId)).eq((Object)"sheep_id", (Object)sheepId);
        ProtSheepInfo protSheepInfo = (ProtSheepInfo)this.sheepInfoMapper.selectOne((Wrapper)sheepInfoQueryWrapper);
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"farm_id", (Object)farmId);
        if (protSheepInfo.getSex() == 0) {
            queryWrapper.eq(StringUtils.isNotBlank((CharSequence)sheepId), (Object)"female_code", (Object)sheepId);
        } else {
            queryWrapper.eq(StringUtils.isNotBlank((CharSequence)sheepId), (Object)"male_code", (Object)sheepId);
        }
        return new Result(ResultCode.SUCCESS, (Object)this.tuppingMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    public Result add(BreedTupping tupping) {
        return new Result(ResultCode.SUCCESS, (Object)this.tuppingMapper.insert((Object)tupping));
    }

    public Result edit(BreedTupping tupping) {
        return new Result(ResultCode.SUCCESS, (Object)this.tuppingMapper.updateById((Object)tupping));
    }

    public Result remove(Map<String, String> paramsMap) {
        String[] split;
        String ids = paramsMap.get("ids");
        for (String s : split = ids.split(",")) {
            this.tuppingMapper.deleteById((Serializable)((Object)s));
        }
        return new Result(ResultCode.SUCCESS);
    }
}

