/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.BreedAblactation;
import com.huimv.admin.entity.ProtSheepInfo;
import com.huimv.admin.entity.ProtTransfer;
import com.huimv.admin.mapper.BreedAblactationMapper;
import com.huimv.admin.mapper.ProtSheepInfoMapper;
import com.huimv.admin.mapper.ProtTransferMapper;
import com.huimv.admin.service.IBreedAblactationService;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BreedAblactationServiceImpl
extends ServiceImpl<BreedAblactationMapper, BreedAblactation>
implements IBreedAblactationService {
    @Autowired
    private BreedAblactationMapper ablactationMapper;
    @Autowired
    private ProtSheepInfoMapper sheepInfoMapper;
    @Autowired
    private ProtTransferMapper transferMapper;

    public Result listPage(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        String sheepId = paramsMap.get("sheepId");
        String ablactationType = paramsMap.get("ablactationType");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).like(StringUtils.isNotBlank((CharSequence)sheepId), (Object)"sheep_id", (Object)sheepId)).eq(StringUtils.isNotBlank((CharSequence)ablactationType), (Object)"ablactation_type", (Object)ablactationType);
        return new Result(ResultCode.SUCCESS, (Object)this.ablactationMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    public Result add(BreedAblactation ablactation) {
        String sheepId = ablactation.getSheepId();
        int count = this.count((Wrapper)new QueryWrapper().eq((Object)"sheep_id", (Object)sheepId));
        if (count > 0) {
            return new Result(Integer.valueOf(10001), "\u7f8a\u53ea\u5df2\u65ad\u5976\uff0c\u65e0\u9700\u518d\u6b21\u65ad\u5976\uff01", false);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sheep_id", (Object)sheepId);
        ProtSheepInfo sheepInfo = (ProtSheepInfo)this.sheepInfoMapper.selectOne((Wrapper)queryWrapper);
        ProtTransfer transfer = new ProtTransfer();
        transfer.setTransfer(Integer.valueOf(1));
        transfer.setNumber(Integer.valueOf(1));
        transfer.setSheepId(sheepId);
        transfer.setFromBuildId(ablactation.getTransferId());
        transfer.setFromBuildName(ablactation.getTransferName());
        transfer.setToBuildId(sheepInfo.getUnitId());
        transfer.setToBuildName(sheepInfo.getUnitName());
        transfer.setFarmId(ablactation.getFarmId());
        transfer.setCreateTime(new Date());
        this.transferMapper.insert((Object)transfer);
        ablactation.setSex(sheepInfo.getSex());
        sheepInfo.setSheepType(ablactation.getTransferType());
        sheepInfo.setUnitId(ablactation.getTransferId());
        sheepInfo.setUnitName(ablactation.getTransferName());
        this.sheepInfoMapper.updateById((Object)sheepInfo);
        this.ablactationMapper.insert((Object)ablactation);
        return new Result(ResultCode.SUCCESS);
    }

    public Result edit(BreedAblactation ablactation) {
        return new Result(ResultCode.SUCCESS, (Object)this.ablactationMapper.updateById((Object)ablactation));
    }

    public Result remove(Map<String, String> paramsMap) {
        String[] split;
        String ids = paramsMap.get("ids");
        for (String s : split = ids.split(",")) {
            this.ablactationMapper.deleteById((Serializable)((Object)s));
        }
        return new Result(ResultCode.SUCCESS);
    }
}

