/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.farm.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.farm.entity.FarmInStock;
import com.huimv.admin.farm.entity.FarmOutStock;
import com.huimv.admin.farm.entity.FarmTransfer;
import com.huimv.admin.farm.mapper.FarmInStockMapper;
import com.huimv.admin.farm.mapper.FarmOutStockMapper;
import com.huimv.admin.farm.mapper.FarmTransferMapper;
import com.huimv.admin.farm.service.IFarmTransferService;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FarmTransferServiceImpl
extends ServiceImpl<FarmTransferMapper, FarmTransfer>
implements IFarmTransferService {
    @Autowired
    private FarmInStockMapper inStockMapper;
    @Autowired
    private FarmOutStockMapper outStockMapper;
    @Autowired
    private FarmTransferMapper transferMapper;

    public Result listPage(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        String transferCode = paramsMap.get("transferCode");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).like(StringUtils.isNotBlank((CharSequence)transferCode), (Object)"transfer_code", (Object)transferCode);
        return new Result(ResultCode.SUCCESS, (Object)this.transferMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    public Result add(FarmTransfer transfer) {
        int count = this.count((Wrapper)new QueryWrapper().eq((Object)"transfer_code", (Object)transfer.getTransferCode()));
        if (count > 0) {
            return new Result(Integer.valueOf(10001), "\u6dfb\u52a0\u5931\u8d25\uff0c\u8c03\u62e8\u5355\u53f7\u5df2\u5b58\u5728\uff01", false);
        }
        FarmInStock inStock = new FarmInStock();
        inStock.setInOrder(transfer.getTransferCode());
        inStock.setFarmId(transfer.getFarmId());
        inStock.setInTime(transfer.getTransferTime());
        inStock.setStockName(transfer.getInStockName());
        inStock.setGoodsCode(transfer.getGoodsCode());
        inStock.setGoodsName(transfer.getGoodsName());
        inStock.setGoodsType(transfer.getGoodsType());
        inStock.setGoodsCode(transfer.getGoodsCode());
        inStock.setNumber(transfer.getNumber());
        inStock.setPrice(transfer.getPrice());
        inStock.setMoney(transfer.getMoney());
        inStock.setInType(Integer.valueOf(3));
        inStock.setRegisterUser(transfer.getRegisterUser());
        inStock.setRemark(transfer.getRemark());
        this.inStockMapper.insert((Object)inStock);
        FarmOutStock outStock = new FarmOutStock();
        outStock.setOutOrder(transfer.getTransferCode());
        outStock.setFarmId(transfer.getFarmId());
        outStock.setOutTime(transfer.getTransferTime());
        outStock.setStockName(transfer.getInStockName());
        outStock.setGoodsCode(transfer.getGoodsCode());
        outStock.setGoodsName(transfer.getGoodsName());
        outStock.setGoodsType(transfer.getGoodsType());
        outStock.setGoodsCode(transfer.getGoodsCode());
        outStock.setNumber(transfer.getNumber());
        outStock.setPrice(transfer.getPrice());
        outStock.setMoney(transfer.getMoney());
        outStock.setOutType(Integer.valueOf(3));
        outStock.setRegisterUser(transfer.getRegisterUser());
        outStock.setRemark(transfer.getRemark());
        this.outStockMapper.insert((Object)outStock);
        this.transferMapper.insert((Object)transfer);
        return new Result(ResultCode.SUCCESS);
    }

    public Result edit(FarmTransfer transfer) {
        int count = this.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"transfer_code", (Object)transfer.getTransferCode())).ne((Object)"id", (Object)transfer.getId()));
        if (count > 0) {
            return new Result(Integer.valueOf(10001), "\u4fee\u6539\u5931\u8d25\uff0c\u8c03\u62e8\u5355\u53f7\u5df2\u5b58\u5728\uff01", false);
        }
        FarmInStock inStock = (FarmInStock)this.inStockMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"in_order", (Object)transfer.getTransferCode()));
        inStock.setInTime(transfer.getTransferTime());
        inStock.setStockName(transfer.getInStockName());
        inStock.setGoodsCode(transfer.getGoodsCode());
        inStock.setGoodsName(transfer.getGoodsName());
        inStock.setGoodsType(transfer.getGoodsType());
        inStock.setGoodsCode(transfer.getGoodsCode());
        inStock.setNumber(transfer.getNumber());
        inStock.setPrice(transfer.getPrice());
        inStock.setMoney(transfer.getMoney());
        inStock.setInType(Integer.valueOf(3));
        inStock.setRegisterUser(transfer.getRegisterUser());
        inStock.setRemark(transfer.getRemark());
        this.inStockMapper.updateById((Object)inStock);
        FarmOutStock outStock = (FarmOutStock)this.outStockMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"out_order", (Object)transfer.getTransferCode()));
        outStock.setOutTime(transfer.getTransferTime());
        outStock.setStockName(transfer.getInStockName());
        outStock.setGoodsCode(transfer.getGoodsCode());
        outStock.setGoodsName(transfer.getGoodsName());
        outStock.setGoodsType(transfer.getGoodsType());
        outStock.setGoodsCode(transfer.getGoodsCode());
        outStock.setNumber(transfer.getNumber());
        outStock.setPrice(transfer.getPrice());
        outStock.setMoney(transfer.getMoney());
        outStock.setOutType(Integer.valueOf(3));
        outStock.setRegisterUser(transfer.getRegisterUser());
        outStock.setRemark(transfer.getRemark());
        this.inStockMapper.updateById((Object)inStock);
        this.transferMapper.updateById((Object)transfer);
        return new Result(ResultCode.SUCCESS);
    }

    public Result remove(Map<String, String> paramsMap) {
        String[] split;
        String ids = paramsMap.get("ids");
        for (String s : split = ids.split(",")) {
            this.transferMapper.deleteById((Serializable)((Object)s));
        }
        return new Result(ResultCode.SUCCESS);
    }
}

