/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.cooperate.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.cooperate.entity.CooperateRecovery;
import com.huimv.admin.cooperate.mapper.CooperateRecoveryMapper;
import com.huimv.admin.cooperate.service.ICooperateRecoveryService;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CooperateRecoveryServiceImpl
extends ServiceImpl<CooperateRecoveryMapper, CooperateRecovery>
implements ICooperateRecoveryService {
    @Autowired
    private CooperateRecoveryMapper recoveryMapper;

    public Result listPage(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"farm_id", (Object)farmId);
        return new Result(ResultCode.SUCCESS, (Object)this.recoveryMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    public Result add(CooperateRecovery recovery) {
        return new Result(ResultCode.SUCCESS, (Object)this.recoveryMapper.insert((Object)recovery));
    }

    public Result edit(CooperateRecovery recovery) {
        return new Result(ResultCode.SUCCESS, (Object)this.recoveryMapper.updateById((Object)recovery));
    }

    public Result remove(Map<String, String> paramsMap) {
        String[] split;
        String ids = paramsMap.get("ids");
        for (String s : split = ids.split(",")) {
            this.recoveryMapper.deleteById((Serializable)((Object)s));
        }
        return new Result(ResultCode.SUCCESS);
    }

    public Result listScreen(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String year = paramsMap.get("year");
        QueryWrapper queryWrapper = new QueryWrapper();
        DateTime dateTime = DateUtil.beginOfYear((Date)new Date());
        queryWrapper.eq((Object)"farm_id", (Object)farmId);
        if ("".equals(year) || null == year) {
            queryWrapper.ge((Object)"recovery_time", (Object)dateTime);
        } else {
            queryWrapper.between((Object)"recovery_time", (Object)(year + "-01-01 00:00:00"), (Object)(year + "-12-31 23:59:59"));
        }
        return new Result(ResultCode.SUCCESS, (Object)this.recoveryMapper.listScreen(queryWrapper));
    }
}

