/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.cooperate.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.cooperate.entity.CooperateMachining;
import com.huimv.admin.cooperate.mapper.CooperateMachiningMapper;
import com.huimv.admin.cooperate.service.ICooperateMachiningService;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CooperateMachiningServiceImpl
extends ServiceImpl<CooperateMachiningMapper, CooperateMachining>
implements ICooperateMachiningService {
    @Autowired
    private CooperateMachiningMapper machiningMapper;

    public Result listPage(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String pageNum = paramsMap.get("pageNum");
        String pageSize = paramsMap.get("pageSize");
        if ("".equals(pageNum) || null == pageNum) {
            pageNum = "1";
            pageSize = "20";
        }
        Page page = new Page((long)Integer.parseInt(pageNum), (long)Integer.parseInt(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"farm_id", (Object)farmId);
        return new Result(ResultCode.SUCCESS, (Object)this.machiningMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    public Result add(CooperateMachining machining) {
        return new Result(ResultCode.SUCCESS, (Object)this.machiningMapper.insert((Object)machining));
    }

    public Result edit(CooperateMachining machining) {
        return new Result(ResultCode.SUCCESS, (Object)this.machiningMapper.updateById((Object)machining));
    }

    public Result remove(Map<String, String> paramsMap) {
        String[] split;
        String ids = paramsMap.get("ids");
        for (String s : split = ids.split(",")) {
            this.machiningMapper.deleteById((Serializable)((Object)s));
        }
        return new Result(ResultCode.SUCCESS);
    }

    public Result listScreen(Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String year = paramsMap.get("year");
        QueryWrapper queryWrapper = new QueryWrapper();
        DateTime dateTime = DateUtil.beginOfYear((Date)new Date());
        queryWrapper.eq((Object)"farm_id", (Object)farmId);
        if ("".equals(year) || null == year) {
            queryWrapper.ge((Object)"machining_time", (Object)dateTime);
        } else {
            queryWrapper.between((Object)"machining_time", (Object)(year + "-01-01 00:00:00"), (Object)(year + "-12-31 23:59:59"));
        }
        return new Result(ResultCode.SUCCESS, (Object)this.machiningMapper.listScreen(queryWrapper));
    }
}

