/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.controller;

import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.SysCamera;
import com.huimv.admin.entity.vo.CameraListVo;
import com.huimv.admin.entity.vo.CameraListsVo;
import com.huimv.admin.service.ISysCameraService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/cameraBase"})
@CrossOrigin
public class SysCameraController {
    @Autowired
    private ISysCameraService cameraService;

    @PostMapping(value={"/list"})
    public Result list(@RequestBody CameraListVo cameraListVo) {
        return this.cameraService.listPage(cameraListVo);
    }

    @PostMapping(value={"/add"})
    public Result add(@RequestBody SysCamera camera) {
        if (camera == null) {
            return new Result(ResultCode.FAIL, (Object)"\u6dfb\u52a0\u5931\u8d25");
        }
        return this.cameraService.add(camera);
    }

    @PostMapping(value={"/update"})
    public Result update(@RequestBody SysCamera camera) {
        return this.cameraService.updates(camera);
    }

    @PostMapping(value={"/updateStatus"})
    public Result updateStatus(@RequestBody Map<String, String> paramsMap) {
        String id = paramsMap.get("id");
        SysCamera sysCamera = (SysCamera)this.cameraService.getById((Serializable)((Object)id));
        sysCamera.setRunStatus(Integer.valueOf(Math.abs(1 - sysCamera.getRunStatus())));
        this.cameraService.updateById((Object)sysCamera);
        return new Result(Integer.valueOf(10000), "\u4fee\u6539\u6210\u529f", true);
    }

    @GetMapping(value={"/remove"})
    public Result remove(@RequestParam(value="ids") List<Integer> ids) {
        this.cameraService.removeByIds(ids);
        return new Result(ResultCode.SUCCESS, (Object)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getCameraDetails"})
    private Result getCameraDetails(@RequestBody CameraListsVo cameraListsVo) throws InterruptedException {
        List list = this.cameraService.getCameraDetails(cameraListsVo);
        return new Result(ResultCode.SUCCESS, (Object)list);
    }
}

