/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.SysCamera;
import com.huimv.admin.entity.SysCameraBrand;
import com.huimv.admin.service.ISysCameraBrandService;
import com.huimv.admin.service.ISysCameraService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cameraBrand"})
@CrossOrigin
public class SysCameraBrandController {
    @Autowired
    private ISysCameraBrandService cameraBrandService;
    @Autowired
    private ISysCameraService cameraService;

    @PostMapping(value={"/list"})
    public Result list(@RequestBody Map<String, Object> params) {
        return this.cameraBrandService.listPage(params);
    }

    @PostMapping(value={"/add"})
    public Result add(@RequestBody SysCameraBrand cameraBrand) {
        int brandName = this.cameraBrandService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"brand_name", (Object)cameraBrand.getBrandName())).eq((Object)"farm_id", (Object)cameraBrand.getFarmId()));
        if (brandName > 0) {
            return new Result(Integer.valueOf(10001), "\u54c1\u724c\u540d\u79f0\u91cd\u590d", false);
        }
        this.cameraBrandService.save((Object)cameraBrand);
        return new Result(Integer.valueOf(10000), "\u6dfb\u52a0\u6210\u529f", true);
    }

    @PostMapping(value={"/update"})
    public Result update(@RequestBody SysCameraBrand cameraArea) {
        this.cameraBrandService.updateById((Object)cameraArea);
        int brandName = this.cameraBrandService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"brand_name", (Object)cameraArea.getBrandName())).eq((Object)"farm_id", (Object)cameraArea.getFarmId()));
        if (brandName > 1) {
            return new Result(Integer.valueOf(10001), "\u54c1\u724c\u540d\u79f0\u91cd\u590d", false);
        }
        String areaName = cameraArea.getBrandName();
        SysCamera camera = new SysCamera();
        if (StringUtils.isNotBlank((CharSequence)areaName)) {
            camera.setBrandName(areaName);
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq((Object)"brand_id", (Object)cameraArea.getId());
        this.cameraService.update((Object)camera, (Wrapper)wrapper);
        return new Result(ResultCode.SUCCESS, (Object)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/remove"})
    public Result remove(@RequestParam(value="ids") List<Integer> ids, @RequestParam(value="farmId") String farmId) {
        return this.cameraBrandService.removeIds(ids, farmId);
    }
}

