/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.huimv.admin.common.utils.IpUtil;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.SysCamera;
import com.huimv.admin.entity.SysCameraArea;
import com.huimv.admin.service.ISysCameraAreaService;
import com.huimv.admin.service.ISysCameraService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/cameraArea"})
@CrossOrigin
public class SysCameraAreaController {
    @Autowired
    private ISysCameraAreaService cameraAreaService;
    @Autowired
    private ISysCameraService cameraService;

    @PostMapping(value={"/list"})
    public Result list(@RequestBody Map<String, Object> params) {
        return this.cameraAreaService.cameraList(params);
    }

    @PostMapping(value={"/add"})
    public Result add(@RequestBody SysCameraArea cameraArea) {
        int brandName = this.cameraAreaService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"area_name", (Object)cameraArea.getAreaName())).eq((Object)"farm_id", (Object)cameraArea.getFarmId()));
        if (brandName > 0) {
            return new Result(Integer.valueOf(100001), "\u533a\u57df\u540d\u79f0\u91cd\u590d", false);
        }
        this.cameraAreaService.save((Object)cameraArea);
        return new Result(Integer.valueOf(10000), "\u6dfb\u52a0\u6210\u529f", true);
    }

    @PostMapping(value={"/update"})
    public Result update(@RequestBody SysCameraArea cameraArea) {
        this.cameraAreaService.updateById((Object)cameraArea);
        int brandName = this.cameraAreaService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"area_name", (Object)cameraArea.getAreaName())).eq((Object)"farm_id", (Object)cameraArea.getFarmId()));
        if (brandName > 1) {
            return new Result(Integer.valueOf(100001), "\u533a\u57df\u540d\u79f0\u91cd\u590d", false);
        }
        String areaName = cameraArea.getAreaName();
        SysCamera camera = new SysCamera();
        if (StringUtils.isNotBlank((CharSequence)areaName)) {
            camera.setAreaName(areaName);
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq((Object)"area_id", (Object)cameraArea.getId());
        this.cameraService.update((Object)camera, (Wrapper)wrapper);
        return new Result(Integer.valueOf(10000), "\u4fee\u6539\u6210\u529f", true);
    }

    @PostMapping(value={"/updateStatus"})
    public Result updateStatus(@RequestBody Map<String, String> paramsMap) {
        String id = paramsMap.get("id");
        SysCameraArea sysCameraArea = (SysCameraArea)this.cameraAreaService.getById((Serializable)((Object)id));
        sysCameraArea.setRunStatus(Integer.valueOf(Math.abs(1 - sysCameraArea.getRunStatus())));
        this.cameraAreaService.updateById((Object)sysCameraArea);
        return new Result(Integer.valueOf(10000), "\u4fee\u6539\u6210\u529f", true);
    }

    @GetMapping(value={"/remove"})
    public Result remove(@RequestParam(value="ids") List<Integer> ids, @RequestParam(value="farmId") String farmId) {
        return this.cameraAreaService.removeIds(ids, farmId);
    }

    @GetMapping(value={"/lsitAndCamera"})
    public Result lsitAndCamera(@RequestParam(value="farmId") Integer farmId) {
        return this.cameraAreaService.lsitAndCamera(farmId);
    }

    @PostMapping(value={"/listCameraByArea"})
    public Result listCameraByArea(@RequestBody Map<String, String> paramsMap) {
        String areaId = paramsMap.get("areaId");
        List list = this.cameraService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysCamera::getAreaId, (Object)areaId)).eq(SysCamera::getRunStatus, (Object)1)).orderByAsc(SysCamera::getSort));
        return new Result(ResultCode.SUCCESS, (Object)list);
    }

    @GetMapping(value={"/listScreenCamera"})
    public Result listScreenCamera(@RequestParam(value="farmId") Integer farmId) {
        return this.cameraAreaService.listScreenCamera(farmId);
    }

    @GetMapping(value={"/getUrl"})
    public void getUrl(HttpServletRequest request, @RequestParam(value="farmId") Integer farmId) {
        String ipAddr = IpUtil.getIpAddr((HttpServletRequest)request);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"farm_id", (Object)farmId);
        List areas = this.cameraAreaService.list((Wrapper)queryWrapper);
        for (SysCameraArea area : areas) {
            area.setPublicUrl(ipAddr + ":9080");
            this.cameraAreaService.updateById((Object)area);
        }
    }
}

