/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.huimv.admin.common.exception.ExceptionEnum;
import com.huimv.admin.common.exception.MiException;
import com.huimv.admin.common.token.TokenSign;
import com.huimv.admin.common.utils.IpTools;
import com.huimv.admin.common.utils.PhoneNumberValidator;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.common.utils.UploadImage;
import com.huimv.admin.common.utils.VerifyUtil;
import com.huimv.admin.entity.SysAccountMultilevel;
import com.huimv.admin.service.ILoginService;
import com.huimv.admin.service.ISysAccountMultilevelService;
import com.huimv.admin.session.AccessToken;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/admin/my"})
@CrossOrigin
public class LoginController {
    @Autowired
    ILoginService iLoginService;
    @Autowired
    private ISysAccountMultilevelService accountMultilevelService;
    @Autowired
    private UploadImage uploadImage;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @RequestMapping(value={"/test"})
    public String logout() {
        return "\u7ebf\u4e0a\u670d\u52a1\u56681";
    }

    @RequestMapping(value={"/logout"})
    public Result logout(@RequestParam(name="accountName", required=true) String accountName, @RequestParam(name="password", required=true) String password) {
        return this.iLoginService.logout();
    }

    @GetMapping(value={"/send"})
    public void createImg(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("image/jpeg");
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expire", 0L);
            VerifyUtil randomValidateCode = new VerifyUtil();
            String code = randomValidateCode.getRandcode(request, response);
            System.out.println(code);
            String remoteHost = request.getRemoteHost();
            this.redisTemplate.opsForValue().set((Object)remoteHost, (Object)code, 300L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            System.out.println("\u83b7\u53d6\u9a8c\u8bc1\u7801\u5f02\u5e38:" + e);
            throw new MiException(ExceptionEnum.VERIFCATION_FAID);
        }
    }

    @PostMapping(value={"/loginMultilevel"})
    public Result loginMultilevel(HttpServletRequest req, @RequestBody Map<String, String> map) {
        String accountName = map.get("accountName");
        String password = map.get("password");
        String remoteHost = req.getRemoteHost();
        Result result = this.iLoginService.loginMultilevel(accountName, password);
        if (result.getCode() == 10000) {
            SysAccountMultilevel accountEntity = (SysAccountMultilevel)result.getData();
            Integer id = accountEntity.getId();
            IpTools.getRemoteHost((HttpServletRequest)req);
            AccessToken accessToken = new AccessToken();
            accessToken.setCreated(new Date());
            accessToken.setAccountName(accountName);
            accessToken.setFarmId(accountEntity.getFarmIds());
            String token = TokenSign.sign((String)accountName, (Integer)id, (String)accountEntity.getFarmIds());
            accessToken.setToken(token);
            accessToken.setId(id);
            accessToken.setLoginIp(remoteHost);
            Integer lastFarmId = accountEntity.getLastFarmId();
            if (ObjectUtil.isEmpty((Object)lastFarmId)) {
                lastFarmId = Integer.parseInt(accountEntity.getFarmIds().split(",")[0]);
            }
            accessToken.setLastFarmId(lastFarmId);
            accessToken.setUserName(accountEntity.getUserName());
            return new Result(ResultCode.SUCCESS, (Object)accessToken);
        }
        return result;
    }

    @PostMapping(value={"/getToken"})
    public String getToken(HttpServletRequest req) {
        String token = TokenSign.sign((String)"superadmin", (Integer)1, null);
        return token;
    }

    @RequestMapping(value={"/logoutClient"})
    public Result logoutClient(HttpServletRequest req, @RequestBody Map<String, String> map) {
        String accountName = map.get("accountName");
        String password = map.get("password");
        String remoteHost = req.getRemoteHost();
        Result result = this.iLoginService.loginMultilevel(accountName, password);
        if (result.getCode() == 10000) {
            SysAccountMultilevel data = (SysAccountMultilevel)result.getData();
            AccessToken accessToken = new AccessToken();
            accessToken.setSysAccountMultilevel(data);
            accessToken.setAccountName(accountName);
            accessToken.setUserName(data.getUserName());
            accessToken.setFarmId(data.getFarmIds());
            accessToken.setId(data.getId());
            String token = TokenSign.sign((String)data.getUserName(), (Integer)data.getId(), (String)data.getFarmIds());
            accessToken.setToken(token);
            Integer lastFarmId = data.getLastFarmId();
            if (ObjectUtil.isEmpty((Object)lastFarmId)) {
                lastFarmId = Integer.parseInt(data.getFarmIds().split(",")[0]);
            }
            accessToken.setLastFarmId(lastFarmId);
            accessToken.setLoginIp(remoteHost);
            return new Result(ResultCode.SUCCESS, (Object)accessToken);
        }
        return result;
    }

    @RequestMapping(value={"/logoutOne"})
    public Result logoutOne(HttpServletRequest req, @RequestBody Map<String, String> map) {
        String password;
        String accountName = map.get("accountName");
        Result result = this.iLoginService.loginMultilevel(accountName, password = map.get("password"));
        if (result.getCode() == 10000) {
            SysAccountMultilevel data = (SysAccountMultilevel)result.getData();
            AccessToken accessToken = new AccessToken();
            String token = TokenSign.sign((String)data.getUserName(), (Integer)data.getId(), (String)data.getFarmIds());
            accessToken.setToken(token);
            return new Result(ResultCode.SUCCESS, (Object)token);
        }
        return result;
    }

    @PostMapping(value={"/register"})
    public Result addAdmission(HttpServletRequest req, @RequestParam(value="userName") String userName, @RequestParam(value="phone") String phone, @RequestParam(value="imgUrl", required=false) MultipartFile imgUrl, @RequestParam(value="openId") String openId) throws IOException {
        String remoteHost = req.getRemoteHost();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)this.accountMultilevelService.getOne((Wrapper)queryWrapper))) {
            return new Result(Integer.valueOf(10001), "\u8be5\u624b\u673a\u53f7\u6216\u8eab\u4efd\u8bc1\u53f7\u5df2\u88ab\u4f7f\u7528\uff01", false);
        }
        if (!PhoneNumberValidator.isValidPhoneNumber((String)phone)) {
            return new Result(Integer.valueOf(10001), "\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff01", false);
        }
        SysAccountMultilevel sysAccountMultilevel = new SysAccountMultilevel();
        sysAccountMultilevel.setUserName(userName);
        sysAccountMultilevel.setPhone(phone);
        sysAccountMultilevel.setAccount(phone);
        sysAccountMultilevel.setPid(Integer.valueOf(0));
        sysAccountMultilevel.setPids("0");
        sysAccountMultilevel.setPassword("123456");
        sysAccountMultilevel.setAccountStatus(Integer.valueOf(1));
        sysAccountMultilevel.setFarmIds("25");
        sysAccountMultilevel.setLastFarmId(Integer.valueOf(25));
        String imageCom = this.uploadImage.getImageCom(imgUrl);
        if (imageCom.equals("\u4e0a\u4f20\u5931\u8d25")) {
            return new Result(Integer.valueOf(10001), "\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff01", false);
        }
        sysAccountMultilevel.setImgUrl(imageCom);
        this.accountMultilevelService.save((Object)sysAccountMultilevel);
        AccessToken accessToken = new AccessToken();
        accessToken.setSysAccountMultilevel(sysAccountMultilevel);
        accessToken.setAccountName(sysAccountMultilevel.getAccount());
        accessToken.setUserName(sysAccountMultilevel.getUserName());
        accessToken.setFarmId(sysAccountMultilevel.getFarmIds());
        accessToken.setId(sysAccountMultilevel.getId());
        String token = TokenSign.sign((String)sysAccountMultilevel.getUserName(), (Integer)sysAccountMultilevel.getId(), (String)sysAccountMultilevel.getFarmIds());
        accessToken.setToken(token);
        Integer lastFarmId = sysAccountMultilevel.getLastFarmId();
        if (ObjectUtil.isEmpty((Object)lastFarmId)) {
            lastFarmId = Integer.parseInt(sysAccountMultilevel.getFarmIds().split(",")[0]);
        }
        accessToken.setLastFarmId(lastFarmId);
        accessToken.setLoginIp(remoteHost);
        return new Result(ResultCode.SUCCESS, (Object)accessToken);
    }
}

