/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.huimv.admin.common.utils.Result;
import com.huimv.admin.common.utils.ResultCode;
import com.huimv.admin.entity.SheepEarmark;
import com.huimv.admin.service.ISheepEarmarkService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/admin/earmark"})
public class EartagController {
    @Autowired
    private ISheepEarmarkService earmarkService;

    @RequestMapping(value={"/earmarkCount"})
    public String earmarkCount(@RequestBody Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String result = HttpUtil.get((String)("https://eartag.alafarms.com/api/manage/device/getNowAllStatus?farmId=" + Integer.parseInt(farmId)));
        return result;
    }

    @RequestMapping(value={"/earmarkList"})
    public JSONObject earmarkList(@RequestBody Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String earmark = paramsMap.get("earmark");
        String deviceCode = "";
        String liveStatus = "";
        String pageNo = paramsMap.get("pageNo");
        String pageSize = paramsMap.get("pageSize");
        if ("".equals(pageNo) || null == pageNo) {
            pageNo = "1";
            pageSize = "20";
        }
        String unitId = "";
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("farmId", (Object)farmId);
        jsonObject2.put("earmark", (Object)earmark);
        jsonObject2.put("deviceCode", (Object)deviceCode);
        jsonObject2.put("liveStatus", (Object)liveStatus);
        jsonObject2.put("pageNo", (Object)pageNo);
        jsonObject2.put("pageSize", (Object)pageSize);
        jsonObject2.put("unitId", (Object)unitId);
        String result = ((HttpRequest)HttpRequest.get((String)"https://eartag.alafarms.com/api/manage2/eartagRegister/listFarmUnitEartagData").header(Header.CONTENT_TYPE, "application/json")).body(jsonObject2.toJSONString()).timeout(30000).execute().body();
        JSONObject jsonObject = JSON.parseObject((String)result);
        return jsonObject;
    }

    @RequestMapping(value={"/earmarkDetail"})
    public JSONObject earmarkDetail(@RequestBody Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String earmark = paramsMap.get("earmark");
        String endDate = paramsMap.get("endDate");
        String endTime = paramsMap.get("endTime");
        String starTime = paramsMap.get("starTime");
        String startDate = paramsMap.get("startDate");
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("farmId", (Object)farmId);
        jsonObject2.put("earmark", (Object)earmark);
        jsonObject2.put("endDate", (Object)endDate);
        jsonObject2.put("endTime", (Object)endTime);
        jsonObject2.put("starTime", (Object)starTime);
        jsonObject2.put("startDate", (Object)startDate);
        String result = ((HttpRequest)HttpRequest.post((String)"https://eartag.alafarms.com/api/manage2/eartagData/getByTimeFilter").header(Header.CONTENT_TYPE, "application/json")).body(jsonObject2.toJSONString()).timeout(30000).execute().body();
        JSONObject jsonObject = JSON.parseObject((String)result);
        return jsonObject;
    }

    @GetMapping(value={"/earmarkScreen"})
    public JSONObject earmarkScreen(@RequestBody Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("farmId", (Object)farmId);
        jsonObject1.put("days", (Object)7);
        String request = ((HttpRequest)HttpRequest.get((String)"https://eartag.alafarms.com/api/manage/eartag/listEartagOnlineAllStatus").body(jsonObject1.toJSONString()).header(Header.CONTENT_TYPE, "application/json")).timeout(30000).execute().body();
        JSONObject jsonObject = JSON.parseObject((String)request);
        return jsonObject;
    }

    @RequestMapping(value={"/list"})
    public Result list(@RequestBody Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String isUser = paramsMap.get("isUser");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).eq(StringUtils.isNotBlank((CharSequence)isUser), (Object)"is_use", (Object)isUser);
        return new Result(ResultCode.SUCCESS, (Object)this.earmarkService.list((Wrapper)queryWrapper));
    }

    @RequestMapping(value={"/add"})
    public Result add(@RequestBody Map<String, String> paramsMap) {
        String farmId = paramsMap.get("farmId");
        String earmark = paramsMap.get("earmark");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"farm_id", (Object)farmId)).eq((Object)"earmark", (Object)earmark);
        if (ObjectUtil.isEmpty((Object)this.earmarkService.getOne((Wrapper)queryWrapper))) {
            SheepEarmark sheepEarmark = new SheepEarmark();
            sheepEarmark.setIsUse(Integer.valueOf(0));
            sheepEarmark.setFarmId(Integer.valueOf(Integer.parseInt(farmId)));
            sheepEarmark.setEarmark(earmark);
            this.earmarkService.save((Object)sheepEarmark);
        }
        return new Result(ResultCode.SUCCESS);
    }
}

