/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.common.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Component
public class UploadImage {
    @Value(value="${img.basePath}")
    private String basePath;
    @Value(value="${img.ip}")
    private String ip;
    @Value(value="${img.user}")
    private String user;
    @Value(value="${img.password}")
    private String password;
    @Value(value="${img.port}")
    public Integer port;
    @Value(value="${img.url}")
    public String url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sshSftp(byte[] bytes, String path, String fileName) throws Exception {
        String filepath = this.basePath + path;
        Session session = null;
        Channel channel = null;
        JSch jSch = new JSch();
        session = this.port <= 0 ? jSch.getSession(this.user, this.ip) : jSch.getSession(this.user, this.ip, this.port.intValue());
        if (session == null) {
            throw new Exception("session is null");
        }
        session.setPassword(this.password);
        session.setConfig("userauth.gssapi-with-mic", "no");
        session.setConfig("StrictHostKeyChecking", "no");
        session.connect(30000);
        OutputStream outstream = null;
        try {
            channel = session.openChannel("sftp");
            channel.connect(1000);
            ChannelSftp sftp = (ChannelSftp)channel;
            sftp.cd(this.basePath);
            SftpATTRS attrs = null;
            try {
                attrs = sftp.stat(filepath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (attrs == null) {
                sftp.mkdir(filepath);
                System.out.println("\u521b\u5efa\u5b50\u76ee\u5f55\uff1a" + filepath);
            }
            sftp.cd(filepath);
            outstream = sftp.put(fileName);
            outstream.write(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outstream != null) {
                outstream.flush();
                outstream.close();
            }
            if (session != null) {
                session.disconnect();
            }
            if (channel != null) {
                channel.disconnect();
            }
            System.out.println("\u4e0a\u4f20\u6210\u529f!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageCom(MultipartFile image) throws IOException {
        InputStream inputStream = image.getInputStream();
        String originalFilename = image.getOriginalFilename();
        String filenameExtension = StringUtils.getFilenameExtension((String)originalFilename);
        String path = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
        try {
            BufferedImage bufImg = ImageIO.read(inputStream);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedImage bufferedImage = new BufferedImage(bufImg.getWidth(), bufImg.getHeight(), 1);
            bufferedImage.createGraphics().drawImage(bufImg, 0, 0, Color.WHITE, null);
            ImageIO.write((RenderedImage)bufferedImage, "jpg", bos);
            byte[] bytes = bos.toByteArray();
            String imgname = UUID.randomUUID() + "." + filenameExtension;
            this.sshSftp(bytes, path, imgname);
            String string = this.url + path + "/" + imgname;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "\u4e0a\u4f20\u5931\u8d25";
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public String uploadImg(MultipartFile image) {
        String originalFilename = image.getOriginalFilename();
        String filenameExtension = StringUtils.getFilenameExtension((String)originalFilename);
        String path = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
        try {
            InputStream inputStream = image.getInputStream();
            BufferedInputStream in = new BufferedInputStream(inputStream);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            byte[] temp = new byte[1024];
            int size = 0;
            while ((size = in.read(temp)) != -1) {
                out.write(temp, 0, size);
            }
            in.close();
            byte[] content = out.toByteArray();
            String imgname = UUID.randomUUID() + "." + filenameExtension;
            this.sshSftp(content, path, imgname);
            return this.url + path + "/" + imgname;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u4e0a\u4f20\u5931\u8d25";
        }
    }
}

