/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.admin.common.utils;

import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class IDCardValidator {
    public static boolean isValidIDCard(String idCardNumber) {
        String pattern = "\\d{17}[0-9Xx]";
        if (!Pattern.matches(pattern, idCardNumber)) {
            return false;
        }
        String idCardDigits = idCardNumber.substring(0, 17);
        if (!IDCardValidator.isNumeric((String)idCardDigits)) {
            return false;
        }
        return IDCardValidator.isValidCheckDigit((String)idCardNumber);
    }

    private static boolean isNumeric(String str) {
        return str.matches("\\d+");
    }

    private static boolean isValidCheckDigit(String idCardNumber) {
        String checkDigit = idCardNumber.substring(17);
        String[] checkCodes = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            int coefficient = Integer.parseInt(idCardNumber.substring(i, i + 1));
            int weight = (int)Math.pow(2.0, 17 - i) % 11;
            sum += coefficient * weight;
        }
        return checkDigit.equalsIgnoreCase(checkCodes[sum % 11]);
    }

    public static void main(String[] args) {
        String idCardNumber = "\u8eab\u4efd\u8bc1\u53f7";
        boolean isValid = IDCardValidator.isValidIDCard((String)idCardNumber);
        if (isValid) {
            System.out.println("\u8eab\u4efd\u8bc1\u53f7\u6b63\u786e\uff01");
        } else {
            System.out.println("\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef\uff01");
        }
    }
}

